/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuProgrammer;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityProgrammer;

public class ScreenProgrammer
extends ScreenFluid {
    public Player player;
    public TileEntityProgrammer tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenProgrammer(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuProgrammer(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityProgrammer)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        int counter;
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/programmer_basic_new.png");
        switch (this.tile.tier) {
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/programmer_basic_new.png");
                break;
            }
            case REINFORCED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/programmer_reinforced_new.png");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 9, y + 36 + 14 - counter, 176, 12 - counter, 14, counter + 2);
        }
        counter = Math.min(this.tile.getProgressScaled(22), 22);
        this.drawTexturedModalRect(x + 121, y + 34, 176, 14, counter + 1, 20);
        if (this.tile.speedMultiplier > 1.0f) {
            this.drawStringCentered(this.font, this.tile.speedMultiplier + "x", x + this.xSize - 16, y + this.ySize / 2 - 16, this.tile.speedMultiplier >= 3.0f ? -23296 : (this.tile.speedMultiplier >= 2.0f ? -65281 : -32640));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        int progress = this.tile.getProgressScaled(100);
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
        if (this.tile.isBurning() && this.tile.canProcess()) {
            int i;
            StringBuilder s = new StringBuilder();
            int count = this.tile.getProgressScaled(100) / 15;
            for (i = 0; i < count; ++i) {
                s.append("#");
            }
            for (i = 0; i < 7 - count; ++i) {
                s.append("-");
            }
            this.font.drawStringWithShadow(String.format("[%s] %d%%", s, progress), 38, 60, color);
        }
        if (!this.tile.isBurning()) {
            if (this.tile.progressTicks > 0) {
                this.font.drawStringWithShadow("Out of energy!", 38, 20, -65536);
            } else {
                this.font.drawStringWithShadow("Idle...", 38, 20, color);
            }
        } else if (!this.tile.canProcess()) {
            this.font.drawStringWithShadow("Interrupted!", 38, 20, -65536);
        } else {
            this.font.drawStringWithShadow("Working...", 38, 20, -16711936);
            if (progress > 10) {
                this.font.drawStringWithShadow("Reading...", 38, 30, -16711936);
            }
            if (progress > 25) {
                this.font.drawStringWithShadow("Copying...", 38, 40, -16711936);
            }
        }
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 60, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 40, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        super.buttonClicked(button);
    }
}

