/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import org.useless.DragonFly;
import org.useless.dragonfly.models.entity.StaticEntityModel;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.IExtendedScreenDraw;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.items.ItemWarpOrb;
import sunsetsatellite.signalindustries.menus.MenuPulsarBlock;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityPulsar;

public class ScreenPulsarBlock
extends ScreenFluid
implements IExtendedScreenDraw {
    public Player player;
    public TileEntityPulsar tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenPulsarBlock(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuPulsarBlock(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityPulsar)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        int counter;
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/pulsar_block_ui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 56, y + 36 + 12 - counter, 176, 12 - counter, 14, counter + 2);
        }
        counter = this.tile.getProgressScaled(24);
        this.drawTexturedModalRect(x + 79, y + 34, 176, 14, counter + 1, 16);
        this.drawString(this.font, (int)((float)this.tile.progressTicks / (float)this.tile.progressMaxTicks * 100.0f) + "%", x + 24, y + 36, -1);
        if (this.tile.getItem(0) != null && this.tile.getItem(0).getItem() instanceof ItemWarpOrb) {
            this.drawStringCentered(this.font, "Warp", x + 140, y + 36, -65281);
        } else {
            this.drawStringCentered(this.font, "Pulse", x + 140, y + 36, -65536);
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 56, Math.round((float)this.height / 2.0f) - 75, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 56, Math.round((float)this.height / 2.0f) - 30, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        super.buttonClicked(button);
    }

    public void drawAfterSlotAndButtonRendering(int mouseX, int mouseY, float partialTick) {
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        Minecraft.getMinecraft().textureManager.loadTexture("/assets/signalindustries/textures/block/pulsar.png").bind();
        if (this.tile.getItem(0) != null && this.tile.getItem(0).getItem() instanceof ItemWarpOrb) {
            Minecraft.getMinecraft().textureManager.loadTexture("/assets/signalindustries/textures/block/pulsar_warp.png").bind();
        }
        StaticEntityModel item = DragonFly.loadEntityModel((String)"geometry.signalindustries.pulsar_item", (double)0.0);
        StaticEntityModel innerCore = DragonFly.loadEntityModel((String)"geometry.signalindustries.pulsar_inner_core", (double)0.0);
        StaticEntityModel outerCore = DragonFly.loadEntityModel((String)"geometry.signalindustries.pulsar_outer_core", (double)0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)44.0f, (float)-10.0f, (float)0.0f);
        GL11.glRotatef((float)(this.tile.orbRotation * 20.0f + partialTick), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
        if (this.tile.fuelBurnTicks <= 0) {
            item.render(Tessellator.instance);
        }
        if (this.tile.progressTicks > this.tile.progressMaxTicks / 2) {
            innerCore.render(Tessellator.instance);
        }
        if (this.tile.progressTicks >= this.tile.progressMaxTicks) {
            outerCore.render(Tessellator.instance);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

