/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.util.PipeMode;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenRestrictPipeConfig
extends Screen {
    public Player entityplayer;
    public TileEntityItemConduit tile;
    public int xSize = 176;
    public int ySize = 166;

    public ScreenRestrictPipeConfig(ContainerInventory playerInv, TileEntity tile) {
        this.entityplayer = playerInv.player;
        this.tile = (TileEntityItemConduit)tile;
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(partialTick);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.enableInventoryLight();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mx, my, partialTick);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    public void init() {
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 63, 15, 15, this.tile.restrictDirections.get(Direction.Y_POS) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 48, 15, 15, this.tile.restrictDirections.get(Direction.Z_POS) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 33, 15, 15, this.tile.restrictDirections.get(Direction.Y_NEG) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(0, Math.round((float)this.width / 2.0f) + 4, Math.round((float)this.height / 2.0f) - 48, 15, 15, this.tile.restrictDirections.get(Direction.X_POS) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f) - 24, Math.round((float)this.height / 2.0f) - 48, 15, 15, this.tile.restrictDirections.get(Direction.X_NEG) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f) + 4, Math.round((float)this.height / 2.0f) - 33, 15, 15, this.tile.restrictDirections.get(Direction.Z_NEG) != false ? "R" : "-"));
        this.buttons.add(new ButtonElement(6, Math.round((float)this.width / 2.0f) + 4 + 22, Math.round((float)this.height / 2.0f) - 48, 50, 15, String.valueOf((Object)this.tile.mode)));
        super.init();
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == 1) {
            this.mc.thePlayer.closeScreen();
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (this.tile != null) {
            if (button.id >= 0 && button.id < 6) {
                if (this.tile.restrictDirections.get(Direction.values()[button.id]).booleanValue()) {
                    this.tile.restrictDirections.replace(Direction.values()[button.id], false);
                } else {
                    this.tile.restrictDirections.replace(Direction.values()[button.id], true);
                }
                String string = button.displayString = this.tile.restrictDirections.get(Direction.values()[button.id]) != false ? "R" : "-";
            }
            if (button.id == 6) {
                switch (this.tile.mode) {
                    case RANDOM: {
                        this.tile.mode = PipeMode.SPLIT;
                        break;
                    }
                    case SPLIT: {
                        this.tile.mode = PipeMode.RANDOM;
                    }
                }
                button.displayString = String.valueOf((Object)this.tile.mode);
            }
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 0, new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
            }
        }
        super.buttonClicked(button);
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Restriction", 36, 6, -12566464);
        this.font.drawString("R/-", 78, 70, -12566464);
        this.font.drawString("Mode", 128, 70, -12566464);
        this.font.drawString("Y+", 26, 22, -1);
        this.font.drawString("Y-", 26, 58, -1);
        this.font.drawString("Z+", 26, 40, -1);
        this.font.drawString("X+", 44, 40, -1);
        this.font.drawString("Z-", 44, 58, -1);
        this.font.drawString("X-", 8, 40, -1);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/ioconfig.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }
}

