/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.pages.lore;

import java.util.ArrayList;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.lang.I18n;

public class IntroPage
extends GuidebookPage {
    private String[] stringLines;
    public final String string;

    public IntroPage(GuidebookSection section, String string) {
        super(section);
        this.string = string;
    }

    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.stringLines == null) {
            this.stringLines = IntroPage.createDescLines(fr, this.string);
        }
        int yOffset = y + 8;
        for (String descLine : this.stringLines) {
            this.drawStringNoShadow(fr, descLine, x + 8, yOffset, 0x505050);
            yOffset += 10;
        }
    }

    private static String[] createDescLines(Font fr, String languageKey) {
        String[] words = I18n.getInstance().translateKey(languageKey).split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (fr.getStringWidth(line + " " + word) > 142) {
                lines.add(line.toString());
                line = new StringBuilder();
            }
            if (word.contains("\n")) {
                String safeWord = word.replace("\r", "");
                String[] wordParts = safeWord.split("\n");
                for (int i = 0; i < wordParts.length; ++i) {
                    if (i > 0) {
                        lines.add(line.toString());
                        line = new StringBuilder();
                    }
                    line.append(wordParts[i]).append(" ");
                }
                continue;
            }
            line.append(word).append(" ");
        }
        lines.add(line.toString());
        return lines.toArray(new String[0]);
    }
}

