/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.pages.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachine;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class CentrifugePage
extends GuidebookPage {
    public static final int RECIPES_PER_PAGE = 2;
    public List<RecipeEntryMachine> recipes;
    public List<SlotGuidebook> slots;
    public Map<RecipeEntryMachine, List<SlotGuidebook>> map;
    private final TooltipElement guiTooltip;
    private final ItemElement guiRenderItem;
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static Player player;
    private static long ticks;

    public CentrifugePage(GuidebookSection section, ArrayList<RecipeEntryMachine> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<SlotGuidebook>();
        this.map = new HashMap<RecipeEntryMachine, List<SlotGuidebook>>();
        player = CentrifugePage.mc.thePlayer;
        player.addStat((Stat)Achievements.OPEN_GUIDEBOOK, 1);
        this.guiTooltip = new TooltipElement(mc);
        this.guiRenderItem = new ItemElement(mc);
        for (RecipeEntryMachine recipe : recipes) {
            ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
            ArrayList<RecipeSymbol> inputSymbol = new ArrayList<RecipeSymbol>();
            for (RecipeExtendedSymbol symbol : (RecipeExtendedSymbol[])recipe.getInput()) {
                if (symbol == null) {
                    inputSymbol.add(null);
                    continue;
                }
                if (symbol.getFluidStack() != null) {
                    FluidStack fluidStack = symbol.getFluidStack();
                    inputSymbol.add(new RecipeSymbol(fluidStack.toItemStack()));
                    continue;
                }
                inputSymbol.add(symbol.asNormalSymbol());
            }
            List acceptedMachines = recipe.parent.getMachine().resolve().stream().filter(S -> {
                Block block = Blocks.getBlock((int)S.itemID);
                if (block != null && block.getLogic() instanceof ITiered) {
                    if (((RecipeProperties)recipe.getData()).thisTierOnly) {
                        return ((ITiered)block.getLogic()).getTier() == ((RecipeProperties)recipe.getData()).tier;
                    }
                    return ((ITiered)block.getLogic()).getTier().ordinal() >= ((RecipeProperties)recipe.getData()).tier.ordinal();
                }
                return false;
            }).collect(Collectors.toList());
            int spacing = 70;
            int offsetY = 52;
            RecipeSymbol outputSymbol = new RecipeSymbol((ItemStack)recipe.getOutput());
            recipeSlots.add(new SlotGuidebook(0, 7, spacing * this.map.size() + offsetY, (RecipeSymbol)inputSymbol.get(0), false, (RecipeEntryBase)recipe));
            recipeSlots.add(new SlotGuidebook(1, 27, spacing * this.map.size() + offsetY - 20, (RecipeSymbol)inputSymbol.get(1), false, (RecipeEntryBase)recipe));
            recipeSlots.add(new SlotGuidebook(2, 27, spacing * this.map.size() + offsetY + 20, (RecipeSymbol)inputSymbol.get(2), false, (RecipeEntryBase)recipe));
            recipeSlots.add(new SlotGuidebook(3, 47, spacing * this.map.size() + offsetY, (RecipeSymbol)inputSymbol.get(3), false, (RecipeEntryBase)recipe));
            recipeSlots.add(new SlotGuidebook(5, 127, spacing * this.map.size() + offsetY, new RecipeSymbol(acceptedMachines), false, (RecipeEntryBase)recipe));
            recipeSlots.add(new SlotGuidebook(4, 103, spacing * this.map.size() + offsetY, outputSymbol, false, (RecipeEntryBase)recipe));
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
        }
    }

    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStringCenteredNoShadow(fr, "Centrifuge", x + 158 - 79, y + 5, -8355712);
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, "No recipes found :(", x + 79, y + 110, -8355712);
        }
        SlotGuidebook mouseOverSlot = null;
        ++ticks;
        for (SlotGuidebook slot : this.slots) {
            if (ticks > 100L) {
                slot.showRandomItem();
                if (this.slots.get(this.slots.size() - 1) == slot) {
                    ticks = 0L;
                }
            }
            if (slot.index != 5) {
                this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            }
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            if (slot.item != null && slot.item.itemID < 16384 && (Blocks.getBlock((int)slot.item.itemID) == Blocks.FLUID_WATER_FLOWING || Blocks.getBlock((int)slot.item.itemID) == Blocks.FLUID_WATER_STILL) && ((Boolean)CentrifugePage.mc.gameSettings.biomeWater.value).booleanValue()) {
                BlockModel blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)Blocks.getBlock((int)slot.item.itemID));
                ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)slot.getItemStack().getItem());
                int waterColor = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)Blocks.FLUID_WATER_FLOWING)).getWorldColor((WorldSource)CentrifugePage.mc.currentWorld, (int)CentrifugePage.mc.thePlayer.x, (int)CentrifugePage.mc.thePlayer.y, (int)CentrifugePage.mc.thePlayer.z);
                Color c = new Color().setARGB(waterColor);
                c.setRGBA(c.getRed(), c.getGreen(), c.getBlue(), 64);
                ((IColorOverride)blockModel).overrideColor((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue(), (float)c.getAlpha());
                this.guiRenderItem.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
                ((IColorOverride)blockModel).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
                continue;
            }
            this.guiRenderItem.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
        }
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryMachine recipe = this.recipes.get(i - 1);
            List<SlotGuidebook> list = this.map.get((Object)recipe);
            this.drawStringCenteredNoShadow(fr, ((RecipeProperties)recipe.getData()).ticks + "t | " + ((RecipeProperties)recipe.getData()).chance * 100.0f + "%", x + list.get((int)(list.size() - 1)).x - 20, y + list.get((int)(list.size() - 1)).y + 18, -14671840);
            this.drawStringCenteredNoShadow(fr, (int)((float)((RecipeProperties)recipe.getData()).cost * ((float)((RecipeProperties)recipe.getData()).ticks / 200.0f)) + " sE", x + list.get((int)(list.size() - 1)).x - 20, y + list.get((int)(list.size() - 1)).y + 26, -3407872);
        }
    }

    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (CentrifugePage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (CentrifugePage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    public void render(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    protected void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/gui/crafting.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryMachine recipe = this.recipes.get(i - 1);
            List<SlotGuidebook> list = this.map.get((Object)recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x - 32, y + list.get((int)(list.size() - 1)).y, 90, 35, 22, 15);
        }
    }

    protected void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL);
            String str = this.guiTooltip.getTooltipText(mouseOverSlot.getItemStack(), showDescription, (Slot)mouseOverSlot);
            if (str.isEmpty()) continue;
            this.guiTooltip.render(str, mouseX, mouseY, 8, -8);
        }
    }

    static {
        ticks = 0L;
    }
}

