/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.sections;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.util.collection.Pair;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineRandomOutput;
import sunsetsatellite.signalindustries.screens.guidebook.SearchableGuidebookSubsection;

public class MachineRandomOutputSection
extends SearchableGuidebookSubsection {
    protected final List<RecipeEntryMachineRandomOutput> recipes;
    protected final Class<? extends GuidebookPage> pageClass;
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;
    private final int recipesPerPage;

    public MachineRandomOutputSection(GuidebookSection parent, List<RecipeEntryMachineRandomOutput> recipes, Class<? extends GuidebookPage> pageClass) {
        super(parent);
        this.recipes = recipes;
        this.pageClass = pageClass;
        try {
            this.recipesPerPage = (Integer)pageClass.getField("RECIPES_PER_PAGE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.reloadSection();
    }

    @Override
    public void reloadSection() {
        this.pages.clear();
        int totalRecipes = this.recipes.size();
        int totalPages = (int)Math.ceil((float)totalRecipes / (float)this.recipesPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        for (int i = 0; i < totalPages; ++i) {
            int j = i * this.recipesPerPage;
            ArrayList<RecipeEntryMachineRandomOutput> list = new ArrayList<RecipeEntryMachineRandomOutput>(this.recipes.subList(j, Math.min(j + this.recipesPerPage, totalRecipes)));
            try {
                this.pages.add(this.pageClass.getConstructor(GuidebookSection.class, ArrayList.class).newInstance(this.parent, list));
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages == null || !Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            ArrayList<RecipeEntryMachineRandomOutput> filteredRecipes = new ArrayList<RecipeEntryMachineRandomOutput>();
            for (RecipeEntryMachineRandomOutput recipe : this.recipes) {
                if (!recipe.matchesQuery(query)) continue;
                filteredRecipes.add(recipe);
            }
            ArrayList<GuidebookPage> guidebookPages = new ArrayList<GuidebookPage>();
            int filteredRecipeSize = filteredRecipes.size();
            int filteredPageCount = filteredRecipeSize / this.recipesPerPage;
            if (filteredPageCount == 0) {
                filteredPageCount = 1;
            }
            for (int i = 0; i < filteredPageCount; ++i) {
                int j = i * this.recipesPerPage;
                ArrayList list = new ArrayList(filteredRecipes.subList(j, Math.min(j + this.recipesPerPage, filteredRecipeSize)));
                if (list.isEmpty()) continue;
                try {
                    guidebookPages.add(this.pageClass.getConstructor(GuidebookSection.class, ArrayList.class).newInstance(this.parent, list));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.filteredPages = Pair.of((Object)query.rawQuery, guidebookPages);
            return guidebookPages;
        }
        return (List)this.filteredPages.getRight();
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

