/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.sections;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.util.collection.Pair;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.signalindustries.SIMultiblocks;
import sunsetsatellite.signalindustries.screens.guidebook.SearchableGuidebookSubsection;
import sunsetsatellite.signalindustries.screens.guidebook.pages.MultiblockMaterialsPage;
import sunsetsatellite.signalindustries.screens.guidebook.pages.MultiblockPage;
import sunsetsatellite.signalindustries.util.SIMultiblock;

public class MultiblockSection
extends SearchableGuidebookSubsection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private final Pair<String, List<GuidebookPage>> filteredPages = null;

    public MultiblockSection(GuidebookSection parent) {
        super(parent);
        this.reloadSection();
    }

    @Override
    public void reloadSection() {
        this.pages.clear();
        List multiblockFields = Arrays.stream(SIMultiblocks.class.getDeclaredFields()).filter(F -> SIMultiblock.class.isAssignableFrom(F.getType())).collect(Collectors.toList());
        try {
            for (Field field : multiblockFields) {
                field.setAccessible(true);
                this.pages.add(new MultiblockPage(this.parent, (Multiblock)field.get(null)));
                this.pages.add(new MultiblockMaterialsPage(this.parent, (Multiblock)field.get(null)));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to add multiblock data to guidebook!", e);
        }
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        ArrayList<GuidebookPage> filtered = new ArrayList<GuidebookPage>();
        for (GuidebookPage page : this.pages) {
            GuidebookPage multiblockPage;
            if (page instanceof MultiblockPage) {
                multiblockPage = (MultiblockPage)page;
                if (!multiblockPage.multiblock.getTranslatedName().contains((CharSequence)query.query.getRight())) continue;
                filtered.add(page);
                continue;
            }
            if (!(page instanceof MultiblockMaterialsPage)) continue;
            multiblockPage = (MultiblockMaterialsPage)page;
            if (!multiblockPage.multiblock.getTranslatedName().contains((CharSequence)query.query.getRight())) continue;
            filtered.add(page);
        }
        return filtered;
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

