/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.IScreenActionListener;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.multipart.api.ISupportsMultiparts;
import sunsetsatellite.catalyst.multipart.api.Multipart;
import sunsetsatellite.signalindustries.blocks.logic.BlockLogicItemConduit;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.tiles.TileEntityFilter;
import sunsetsatellite.signalindustries.tiles.TileEntityStorageContainer;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWithName;
import sunsetsatellite.signalindustries.util.PipeMode;
import sunsetsatellite.signalindustries.util.PipeType;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class TileEntityItemConduit
extends TileEntityWithName
implements IScreenActionListener,
ISupportsMultiparts {
    public static int TRANSFER_TICKS = 60;
    public static int EXTRACT_TICKS = 40;
    private final TickTimer extractTimer = new TickTimer((Object)this, this::extractItem, EXTRACT_TICKS, true);
    private final List<PipeItem> contents = new ArrayList<PipeItem>();
    public PipeMode mode = PipeMode.RANDOM;
    private final Random random = new Random();
    public Tier tier = Tier.PROTOTYPE;
    public PipeType type = PipeType.NORMAL;
    public Map<Direction, Boolean> restrictDirections = new HashMap<Direction, Boolean>();
    public Map<Direction, Boolean> noConnectDirections = new HashMap<Direction, Boolean>();
    public boolean sensorActive;
    public int sensorMode = 0;
    public int sensorAmount = 0;
    public boolean sensorUseMeta = true;
    public boolean sensorUseData = false;
    public ItemStack sensorStack = null;
    public final HashMap<Direction, Multipart> parts = (HashMap)Catalyst.mapOf((Object[])Direction.values(), (Object[])new Multipart[Direction.values().length]);

    public TileEntityItemConduit() {
        for (Direction dir : Direction.values()) {
            this.restrictDirections.put(dir, false);
            this.noConnectDirections.put(dir, false);
        }
    }

    public List<PipeItem> getContents() {
        return this.contents;
    }

    public boolean addItem(ItemStack stack, Direction entry) {
        HashMap<Direction, TileEntity> surroundings = this.getSurroundings();
        List<Map.Entry<Direction, TileEntity>> exitList = surroundings.entrySet().stream().filter(E -> E.getKey() != entry).collect(Collectors.toList());
        if (exitList.isEmpty()) {
            return false;
        }
        Direction exit = null;
        if (this.mode == PipeMode.RANDOM) {
            exit = this.pickRandomExitDirection(exitList, stack);
        } else if (this.mode == PipeMode.SPLIT) {
            List exits = exitList.stream().filter(E -> surroundings.get(E.getKey()) instanceof IItemIO || surroundings.get(E.getKey()) instanceof Container || surroundings.get(E.getKey()) instanceof TileEntityItemConduit).map(Map.Entry::getKey).collect(Collectors.toList());
            if (exits.isEmpty()) {
                return false;
            }
            if (stack.stackSize % exits.size() == 0) {
                int split = stack.stackSize / exits.size();
                for (Direction dir : exits) {
                    if (split <= 0) continue;
                    this.contents.add(new PipeItem(new ItemStack(stack.itemID, split, stack.getMetadata()), entry, dir));
                }
            } else {
                int split = stack.stackSize / exits.size();
                int remaider = stack.stackSize % exits.size();
                for (Direction dir : exits) {
                    if (split + remaider <= 0) continue;
                    this.contents.add(new PipeItem(new ItemStack(stack.itemID, split + remaider, stack.getMetadata()), entry, dir));
                    remaider = 0;
                }
            }
            return true;
        }
        if (exit == null) {
            return false;
        }
        TileEntity exitTile = surroundings.get(exit);
        if (!(exitTile instanceof IItemIO || exitTile instanceof TileEntityStorageContainer || exitTile instanceof Container || exitTile instanceof TileEntityItemConduit)) {
            return false;
        }
        PipeItem pipeItem = new PipeItem(stack, entry, exit);
        this.contents.add(pipeItem);
        return true;
    }

    public void dropItem(PipeItem item, Iterator<PipeItem> iter) {
        if (this.contents.contains(item)) {
            Vec3f dirVec = item.exit.getVecF().divide(2.0);
            Vec3f offset = new Vec3f((double)this.x, (double)this.y, (double)this.z).add(dirVec).add(0.5);
            EntityItem entityitem = new EntityItem(this.worldObj, (double)((float)offset.x), (double)((float)offset.y), (double)((float)offset.z), item.stack);
            float multiplier = 0.05f;
            entityitem.xd = dirVec.x * (double)multiplier;
            entityitem.yd = dirVec.y * (double)multiplier;
            entityitem.zd = dirVec.z * (double)multiplier;
            this.worldObj.entityJoinedWorld((Entity)entityitem);
            if (iter != null) {
                iter.remove();
            } else {
                this.contents.remove(item);
            }
        }
    }

    public void extractItem() {
        HashMap<Direction, TileEntity> surroundings = this.getSurroundings();
        List entryList = surroundings.entrySet().stream().filter(E -> !(E.getValue() instanceof TileEntityItemConduit)).collect(Collectors.toList());
        if (entryList.isEmpty()) {
            return;
        }
        Direction entry = null;
        entry = (Direction)((Map.Entry)entryList.get(this.random.nextInt(entryList.size()))).getKey();
        if (entry == null) {
            return;
        }
        TileEntity entryTile = surroundings.get(entry);
        if (entryTile instanceof IItemIO && entryTile instanceof Container) {
            int slot;
            IItemIO io = (IItemIO)entryTile;
            Container inv = (Container)entryTile;
            if ((io.getItemIOForSide(entry.getOpposite()) == Connection.OUTPUT || io.getItemIOForSide(entry.getOpposite()) == Connection.BOTH) && inv.getItem(slot = io.getActiveItemSlotForSide(entry.getOpposite())) != null) {
                ItemStack stack = inv.getItem(slot);
                stack = stack.stackSize >= 8 ? stack.splitStack(8) : stack.splitStack(stack.stackSize);
                Direction finalEntry = entry;
                List<Map.Entry<Direction, TileEntity>> exitList = surroundings.entrySet().stream().filter(E -> E.getKey() != finalEntry).collect(Collectors.toList());
                if (exitList.isEmpty()) {
                    return;
                }
                Direction exit = null;
                if (this.mode == PipeMode.RANDOM) {
                    exit = this.pickRandomExitDirection(exitList, stack);
                } else if (this.mode == PipeMode.SPLIT) {
                    List exits = exitList.stream().filter(E -> surroundings.get(E.getKey()) instanceof IItemIO || surroundings.get(E.getKey()) instanceof TileEntityStorageContainer || surroundings.get(E.getKey()) instanceof Container || surroundings.get(E.getKey()) instanceof TileEntityItemConduit).map(Map.Entry::getKey).collect(Collectors.toList());
                    if (exits.isEmpty()) {
                        return;
                    }
                    if (stack.stackSize % exits.size() == 0) {
                        int split = stack.stackSize / exits.size();
                        for (Direction dir : exits) {
                            if (split <= 0) continue;
                            this.contents.add(new PipeItem(new ItemStack(stack.itemID, split, stack.getMetadata()), entry, dir));
                        }
                    } else {
                        int split = stack.stackSize / exits.size();
                        int remaider = stack.stackSize % exits.size();
                        for (Direction dir : exits) {
                            if (split + remaider <= 0) continue;
                            this.contents.add(new PipeItem(new ItemStack(stack.itemID, split + remaider, stack.getMetadata()), entry, dir));
                            remaider = 0;
                        }
                    }
                    if (stack.stackSize <= 0) {
                        inv.setItem(slot, null);
                    }
                    return;
                }
                if (exit == null) {
                    return;
                }
                TileEntity exitTile = surroundings.get(exit);
                if (!(exitTile instanceof IItemIO || exitTile instanceof Container || exitTile instanceof TileEntityStorageContainer || exitTile instanceof TileEntityItemConduit)) {
                    return;
                }
                PipeItem pipeItem = new PipeItem(stack, entry, exit);
                this.contents.add(pipeItem);
                if (inv.getItem((int)slot).stackSize <= 0) {
                    inv.setItem(slot, null);
                }
            }
        }
    }

    private void acceptItem(Direction entry, PipeItem item, TileEntityItemConduit conduit) {
        HashMap<Direction, TileEntity> surroundings = this.getSurroundings();
        List entryList = surroundings.entrySet().stream().filter(E -> E.getValue() instanceof TileEntityItemConduit).collect(Collectors.toList());
        List directions = entryList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        if (directions.contains(entry)) {
            List<Map.Entry<Direction, TileEntity>> exitList = surroundings.entrySet().stream().filter(E -> E.getKey() != entry).collect(Collectors.toList());
            if (exitList.isEmpty()) {
                return;
            }
            Direction exit = null;
            if (this.mode == PipeMode.RANDOM) {
                exit = this.pickRandomExitDirection(exitList, item.stack);
            } else if (this.mode == PipeMode.SPLIT) {
                List exits = exitList.stream().filter(E -> surroundings.get(E.getKey()) instanceof IItemIO || surroundings.get(E.getKey()) instanceof TileEntityStorageContainer || surroundings.get(E.getKey()) instanceof Container || surroundings.get(E.getKey()) instanceof TileEntityItemConduit).map(Map.Entry::getKey).collect(Collectors.toList());
                if (exits.isEmpty()) {
                    return;
                }
                if (((PipeItem)item).stack.stackSize % exits.size() == 0) {
                    int split = ((PipeItem)item).stack.stackSize / exits.size();
                    conduit.contents.remove(item);
                    for (Direction dir : exits) {
                        if (split <= 0) continue;
                        this.contents.add(new PipeItem(new ItemStack(((PipeItem)item).stack.itemID, split, item.stack.getMetadata()), entry, dir));
                    }
                } else {
                    int split = ((PipeItem)item).stack.stackSize / exits.size();
                    int remaider = ((PipeItem)item).stack.stackSize % exits.size();
                    conduit.contents.remove(item);
                    for (Direction dir : exits) {
                        if (split + remaider <= 0) continue;
                        this.contents.add(new PipeItem(new ItemStack(((PipeItem)item).stack.itemID, split + remaider, item.stack.getMetadata()), entry, dir));
                        remaider = 0;
                    }
                }
                return;
            }
            if (exit == null) {
                return;
            }
            TileEntity exitTile = surroundings.get(exit);
            if (!(exitTile instanceof IItemIO || exitTile instanceof TileEntityStorageContainer || exitTile instanceof Container || exitTile instanceof TileEntityItemConduit)) {
                return;
            }
            conduit.contents.remove(item);
            this.contents.add(new PipeItem(item.stack, entry, exit));
        }
    }

    private Direction pickRandomExitDirection(List<Map.Entry<Direction, TileEntity>> exitList, ItemStack stack) {
        ArrayList<Direction> blockedDirs = new ArrayList<Direction>();
        for (Map.Entry<Object, Object> entry : exitList) {
            if (entry.getValue() instanceof IItemIO || entry.getValue() instanceof Container) {
                if (entry.getValue() instanceof IItemIO) {
                    IItemIO io = (IItemIO)entry.getValue();
                    if (io.getItemIOForSide(((Direction)entry.getKey()).getOpposite()) == Connection.INPUT || io.getItemIOForSide(((Direction)entry.getKey()).getOpposite()) == Connection.BOTH) {
                        return (Direction)entry.getKey();
                    }
                    blockedDirs.add((Direction)entry.getKey());
                    continue;
                }
                Container inv = (Container)entry.getValue();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    if (inv.getItem(i) == null) {
                        return (Direction)entry.getKey();
                    }
                    if (!inv.getItem(i).isItemEqual(stack) || inv.getItem((int)i).stackSize + stack.stackSize > inv.getMaxStackSize() || inv.getItem((int)i).stackSize + stack.stackSize > inv.getItem(i).getMaxStackSize(inv)) continue;
                    return (Direction)entry.getKey();
                }
                blockedDirs.add((Direction)entry.getKey());
                continue;
            }
            if (!(entry.getValue() instanceof TileEntityStorageContainer)) continue;
            TileEntityStorageContainer container = (TileEntityStorageContainer)entry.getValue();
            if (container.contents == null || container.contents.isItemEqual(stack) && container.contents.getData().equals((Object)stack.getData()) && container.contents.stackSize < container.capacity) {
                return (Direction)entry.getKey();
            }
            blockedDirs.add((Direction)entry.getKey());
        }
        this.restrictDirections.forEach((D, B) -> {
            if (B.booleanValue() && !blockedDirs.contains(D)) {
                blockedDirs.add((Direction)D);
            }
        });
        this.noConnectDirections.forEach((D, B) -> {
            if (B.booleanValue() && !blockedDirs.contains(D)) {
                blockedDirs.add((Direction)D);
            }
        });
        exitList = exitList.stream().filter(E -> !blockedDirs.contains(E.getKey())).collect(Collectors.toList());
        if (exitList.isEmpty()) {
            return null;
        }
        if (exitList.size() == 1) {
            return (Direction)exitList.get(0).getKey();
        }
        return (Direction)exitList.get(this.random.nextInt(exitList.size())).getKey();
    }

    public void tick() {
        super.tick();
        this.worldObj.markBlockDirty(this.x, this.y, this.z);
        this.worldObj.notifyBlocksOfNeighborChange(this.x, this.y, this.z, this.sensorActive ? 15 : 0);
        if (this.worldObj != null && this.getBlock() != null) {
            this.tier = ((ITiered)this.getBlock().getLogic()).getTier();
            this.type = ((BlockLogicItemConduit)this.getBlock().getLogic()).type;
        }
        switch (this.tier) {
            case BASIC: {
                TRANSFER_TICKS = 60;
                this.extractTimer.max = EXTRACT_TICKS = 40;
                break;
            }
            default: {
                TRANSFER_TICKS = 120;
                this.extractTimer.max = EXTRACT_TICKS = 80;
            }
        }
        if (EnvironmentHelper.isClientWorld()) {
            return;
        }
        this.extractTimer.tick();
        this.contents.removeIf(P -> ((PipeItem)P).stack == null);
        Iterator<PipeItem> iter = this.contents.iterator();
        while (iter.hasNext()) {
            PipeItem next = iter.next();
            if (!next.insertTimer.isPaused()) continue;
            this.dropItem(next, iter);
        }
        this.sensorActive = false;
        for (PipeItem pipeItem : this.contents.toArray(new PipeItem[0])) {
            pipeItem.insertTimer.tick();
            ItemStack stack = pipeItem.stack;
            if (stack == null || this.sensorStack == null || this.type != PipeType.SENSOR || stack.itemID != this.sensorStack.itemID) continue;
            this.sensorActive = this.checkIfValidForSensor(stack);
        }
    }

    private boolean checkIfValidForSensor(ItemStack stack) {
        boolean yes = false;
        switch (this.sensorMode) {
            case 0: {
                yes = stack.stackSize == this.sensorAmount;
                break;
            }
            case 1: {
                yes = stack.stackSize != this.sensorAmount;
                break;
            }
            case 2: {
                yes = stack.stackSize > this.sensorAmount;
                break;
            }
            case 3: {
                yes = stack.stackSize < this.sensorAmount;
                break;
            }
            case 4: {
                yes = stack.stackSize >= this.sensorAmount;
                break;
            }
            case 5: {
                boolean bl = yes = stack.stackSize <= this.sensorAmount;
            }
        }
        if (this.sensorUseMeta && stack.getMetadata() != this.sensorStack.getMetadata()) {
            yes = false;
        }
        if (this.sensorUseData && !stack.getData().equals((Object)this.sensorStack.getData())) {
            yes = false;
        }
        return yes;
    }

    public HashMap<Direction, TileEntity> getSurroundings() {
        HashMap<Direction, TileEntity> surroundings = new HashMap<Direction, TileEntity>();
        for (Direction dir : Direction.values()) {
            TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
            if (tile == null || !(tile instanceof Container) && !(tile instanceof TileEntityItemConduit) && !(tile instanceof TileEntityStorageContainer) || this.noConnectDirections.get(dir).booleanValue()) continue;
            surroundings.put(dir, tile);
        }
        return surroundings;
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sensorActive = nbttagcompound.getBoolean("IsActive");
        this.sensorMode = nbttagcompound.getInteger("SensorMode");
        this.sensorAmount = nbttagcompound.getInteger("CheckAmount");
        this.sensorUseMeta = nbttagcompound.getBoolean("UseMeta");
        this.sensorUseData = nbttagcompound.getBoolean("UseData");
        if (nbttagcompound.containsKey("SensorStack")) {
            this.sensorStack = ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound.getCompound("SensorStack"));
        }
        CompoundTag items = nbttagcompound.getCompound("Items");
        CompoundTag restrict = nbttagcompound.getCompound("Restrictions");
        CompoundTag noConnect = nbttagcompound.getCompound("NoConnect");
        this.contents.clear();
        for (Tag value : items.getValues()) {
            if (!(value instanceof CompoundTag)) continue;
            CompoundTag itemNbt = (CompoundTag)value;
            PipeItem item = new PipeItem(itemNbt);
            this.contents.add(item);
        }
        for (Tag value : restrict.getValues()) {
            if (!(value instanceof ByteTag)) continue;
            this.restrictDirections.replace(Direction.getFromName((String)value.getTagName()), (Byte)value.getValue() == 1);
        }
        for (Tag value : noConnect.getValues()) {
            if (!(value instanceof ByteTag)) continue;
            this.noConnectDirections.replace(Direction.getFromName((String)value.getTagName()), (Byte)value.getValue() == 1);
        }
        CompoundTag coversNbt = nbttagcompound.getCompound("Parts");
        for (Map.Entry entry : ((Map)coversNbt.getValue()).entrySet()) {
            Direction dir = Direction.values()[Integer.parseInt((String)entry.getKey())];
            CompoundTag partTag = (CompoundTag)entry.getValue();
            this.parts.put(dir, new Multipart(partTag));
        }
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        Boolean B;
        Direction D;
        super.writeToNBT(nbttagcompound);
        CompoundTag items = new CompoundTag();
        CompoundTag restrict = new CompoundTag();
        CompoundTag noConnect = new CompoundTag();
        for (Map.Entry<Direction, Boolean> entry : this.restrictDirections.entrySet()) {
            D = entry.getKey();
            B = entry.getValue();
            restrict.putBoolean(D.getName(), B.booleanValue());
        }
        for (Map.Entry<Direction, Boolean> entry : this.noConnectDirections.entrySet()) {
            D = entry.getKey();
            B = entry.getValue();
            noConnect.putBoolean(D.getName(), B.booleanValue());
        }
        for (int i = 0; i < this.contents.size(); ++i) {
            CompoundTag itemNbt = new CompoundTag();
            PipeItem item = this.contents.get(i);
            item.writeToNBT(itemNbt);
            items.put(String.valueOf(i), (Tag)itemNbt);
        }
        nbttagcompound.put("NoConnect", (Tag)noConnect);
        nbttagcompound.put("Restrictions", (Tag)restrict);
        nbttagcompound.put("Items", (Tag)items);
        nbttagcompound.putBoolean("IsActive", this.sensorActive);
        nbttagcompound.putInt("CheckAmount", this.sensorAmount);
        nbttagcompound.putInt("SensorMode", this.sensorMode);
        nbttagcompound.putBoolean("UseMeta", this.sensorUseMeta);
        nbttagcompound.putBoolean("UseData", this.sensorUseData);
        if (this.sensorStack != null) {
            CompoundTag itemNbt = new CompoundTag();
            this.sensorStack.writeToNBT(itemNbt);
            nbttagcompound.putCompound("SensorStack", itemNbt);
        }
        CompoundTag coversNbt = new CompoundTag();
        for (Map.Entry<Direction, Multipart> entry : this.parts.entrySet()) {
            if (entry.getValue() == null) continue;
            CompoundTag partNbt = new CompoundTag();
            entry.getValue().writeToNbt(partNbt);
            coversNbt.putCompound(String.valueOf(entry.getKey().ordinal()), partNbt);
        }
        nbttagcompound.putCompound("Parts", coversNbt);
    }

    public HashMap<Direction, Multipart> getParts() {
        return this.parts;
    }

    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        List stacks = this.getContents().stream().map(PipeItem::getStack).collect(Collectors.toList());
        for (ItemStack itemstack : stacks) {
            if (itemstack == null) continue;
            Random random = new Random();
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int i1 = random.nextInt(21) + 10;
                if (i1 > itemstack.stackSize) {
                    i1 = itemstack.stackSize;
                }
                itemstack.stackSize -= i1;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                float f3 = 0.05f;
                entityitem.xd = (float)random.nextGaussian() * f3;
                entityitem.yd = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.zd = (float)random.nextGaussian() * f3;
                world.entityJoinedWorld((Entity)entityitem);
            }
        }
    }

    public void buttonClicked(int id, int button, int channel) {
        block0 : switch (this.type) {
            case RESTRICT: {
                if (id >= 0 && id < 6) {
                    if (this.restrictDirections.get(Direction.values()[id]).booleanValue()) {
                        this.restrictDirections.replace(Direction.values()[id], false);
                    } else {
                        this.restrictDirections.replace(Direction.values()[id], true);
                    }
                }
                if (id != 6) break;
                switch (this.mode) {
                    case RANDOM: {
                        this.mode = PipeMode.SPLIT;
                        break;
                    }
                    case SPLIT: {
                        this.mode = PipeMode.RANDOM;
                    }
                }
                break;
            }
            case SENSOR: {
                if (id == 2 && this.sensorAmount > 0) {
                    --this.sensorAmount;
                }
                if (id == 1) {
                    ++this.sensorAmount;
                }
                if (id == 3) {
                    boolean bl = this.sensorUseMeta = !this.sensorUseMeta;
                }
                if (id == 4) {
                    boolean bl = this.sensorUseData = !this.sensorUseData;
                }
                if (id == 0) {
                    ++this.sensorMode;
                    if (this.sensorMode == 6) {
                        this.sensorMode = 0;
                    }
                }
                if (id != 5) break;
                switch (this.mode) {
                    case RANDOM: {
                        this.mode = PipeMode.SPLIT;
                        break block0;
                    }
                    case SPLIT: {
                        this.mode = PipeMode.RANDOM;
                    }
                }
            }
        }
    }

    public class PipeItem {
        private final ItemStack stack;
        private final Direction entry;
        private final Direction exit;
        private final TickTimer insertTimer = new TickTimer((Object)this, this::insertItem, TRANSFER_TICKS, false);

        public ItemStack getStack() {
            return this.stack;
        }

        public Direction getEntry() {
            return this.entry;
        }

        public Direction getExit() {
            return this.exit;
        }

        public int getTicks() {
            return this.insertTimer.value;
        }

        public PipeItem(ItemStack stack, Direction entry, Direction exit) {
            this.stack = stack;
            this.entry = entry;
            this.exit = exit;
        }

        public PipeItem(CompoundTag tag) {
            this.stack = ItemStack.readItemStackFromNbt((CompoundTag)tag.getCompound("stack"));
            this.entry = Direction.getDirectionFromSide((int)tag.getInteger("entry"));
            this.exit = Direction.getDirectionFromSide((int)tag.getInteger("exit"));
            this.insertTimer.value = tag.getInteger("ticks");
        }

        public void writeToNBT(CompoundTag compoundTag) {
            CompoundTag stackNbt = new CompoundTag();
            this.stack.writeToNBT(stackNbt);
            compoundTag.putInt("entry", this.entry.getSideNumber());
            compoundTag.putInt("exit", this.exit.getSideNumber());
            compoundTag.putInt("ticks", this.insertTimer.value);
            compoundTag.putCompound("stack", stackNbt);
        }

        public void insertItem() {
            TileEntity tileEntity = this.exit.getTileEntity((WorldSource)TileEntityItemConduit.this.worldObj, (TileEntity)TileEntityItemConduit.this);
            Direction entry = this.exit.getOpposite();
            if (tileEntity instanceof TileEntityFilter) {
                ((TileEntityFilter)tileEntity).sort(entry.getOpposite(), this, TileEntityItemConduit.this);
                return;
            }
            if (tileEntity instanceof TileEntityStorageContainer) {
                TileEntityStorageContainer container = (TileEntityStorageContainer)tileEntity;
                container.insertStack(this.stack);
            }
            if (tileEntity instanceof IItemIO && tileEntity instanceof Container) {
                IItemIO io = (IItemIO)tileEntity;
                Container inv = (Container)tileEntity;
                if (io.getItemIOForSide(entry) == Connection.INPUT || io.getItemIOForSide(entry) == Connection.BOTH) {
                    int slot = io.getActiveItemSlotForSide(entry, this.stack);
                    ItemStack tileStack = inv.getItem(slot);
                    if (tileStack == null || tileStack.isItemEqual(this.stack) && tileStack.stackSize + this.stack.stackSize <= tileStack.getMaxStackSize()) {
                        if (tileStack == null) {
                            inv.setItem(slot, this.stack);
                        } else {
                            tileStack.stackSize += this.stack.stackSize;
                        }
                        TileEntityItemConduit.this.contents.remove(this);
                    } else if (tileStack.isItemEqual(this.stack)) {
                        int remainder = Math.min(tileStack.getMaxStackSize() - tileStack.stackSize, this.stack.stackSize);
                        if (remainder <= 0) {
                            return;
                        }
                        this.stack.stackSize -= remainder;
                        tileStack.stackSize += remainder;
                    }
                }
            } else if (!(tileEntity instanceof IItemIO) && tileEntity instanceof Container) {
                Container inv = (Container)tileEntity;
                int slot = 0;
                while (this.stack.stackSize > 0 && slot < inv.getContainerSize()) {
                    ItemStack tileStack = inv.getItem(slot);
                    if (tileStack == null) {
                        inv.setItem(slot, this.stack);
                        TileEntityItemConduit.this.contents.remove(this);
                        break;
                    }
                    if (tileStack.isItemEqual(this.stack)) {
                        int remainder = Math.min(tileStack.getMaxStackSize() - tileStack.stackSize, this.stack.stackSize);
                        if (remainder <= 0) {
                            ++slot;
                            continue;
                        }
                        this.stack.stackSize -= remainder;
                        tileStack.stackSize += remainder;
                    }
                    ++slot;
                }
                if (this.stack.stackSize <= 0) {
                    TileEntityItemConduit.this.contents.remove(this);
                }
            } else if (tileEntity instanceof TileEntityItemConduit) {
                ((TileEntityItemConduit)tileEntity).acceptItem(entry, this, TileEntityItemConduit.this);
            }
        }
    }
}

