/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.b100.utils.ReflectUtils;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.IScreenActionListener;
import sunsetsatellite.catalyst.core.util.conduit.ConduitCapability;
import sunsetsatellite.catalyst.core.util.conduit.IConduitBlock;
import sunsetsatellite.catalyst.core.util.conduit.IMultiConduit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidContainer;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidPipe;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.multipart.api.ISupportsMultiparts;
import sunsetsatellite.catalyst.multipart.api.Multipart;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.INamedTileEntity;
import sunsetsatellite.signalindustries.interfaces.ITiered;

public class TileEntityMultiConduit
extends TileEntityFluidContainer
implements INamedTileEntity,
IMultiConduit,
IScreenActionListener,
ISupportsMultiparts {
    public IConduitBlock[] conduits = new IConduitBlock[4];
    public HashMap<Direction, Integer> conduitConnections = (HashMap)Catalyst.mapOf((Object[])Direction.values(), (Object[])((Integer[])Catalyst.arrayFill((Object[])new Integer[Direction.values().length], (Object)-1)));
    public int maxRememberTicks = 100;
    public int rememberTicks = 0;
    public TileEntityFluidContainer[] lastPipes = new TileEntityFluidContainer[4];
    public final HashMap<Direction, Multipart> parts = (HashMap)Catalyst.mapOf((Object[])Direction.values(), (Object[])new Multipart[Direction.values().length]);

    public TileEntityMultiConduit() {
        this.fluidContents = new FluidStack[0];
        this.fluidCapacity = new int[0];
        this.transferSpeed = 0;
        this.acceptedFluids.clear();
        this.fluidConnections.replaceAll((D, C) -> Connection.BOTH);
    }

    public void tick() {
        this.worldObj.markBlockDirty(this.x, this.y, this.z);
        if (Arrays.stream(this.conduits).allMatch(Objects::isNull) && !this.acceptedFluids.isEmpty()) {
            this.acceptedFluids.clear();
        }
        for (int i = 0; i < this.conduits.length; ++i) {
            IConduitBlock conduit = this.conduits[i];
            if (conduit == null) continue;
            ++this.rememberTicks;
            if (this.rememberTicks >= this.maxRememberTicks) {
                this.rememberTicks = 0;
                Arrays.fill(this.lastPipes, null);
            }
            HashMap<Direction, TileEntity> neighbors = new HashMap<Direction, TileEntity>();
            for (Direction dir : Direction.values()) {
                neighbors.put(dir, dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this));
            }
            int finalI = i;
            neighbors.forEach((side, tile) -> {
                if (tile instanceof TileEntityMultiConduit && !tile.equals(this.lastPipes[finalI])) {
                    TileEntityMultiConduit multiConduit = (TileEntityMultiConduit)tile;
                    if (multiConduit.fluidContents.length <= finalI || this.fluidContents.length <= finalI) {
                        return;
                    }
                    FluidStack intFluid = this.getFluidInSlot(finalI);
                    FluidStack extFluid = multiConduit.getFluidInSlot(finalI);
                    if (intFluid != null && extFluid == null) {
                        this.lastPipes[finalI] = (TileEntityMultiConduit)tile;
                        ((TileEntityMultiConduit)tile).lastPipes[finalI] = this;
                        this.give((Direction)side, finalI, finalI);
                    } else if (intFluid == null && extFluid != null) {
                        this.lastPipes[finalI] = (TileEntityMultiConduit)tile;
                        ((TileEntityMultiConduit)tile).lastPipes[finalI] = this;
                        this.take(extFluid, (Direction)side, finalI);
                    } else if (intFluid != null) {
                        this.lastPipes[finalI] = (TileEntityMultiConduit)tile;
                        ((TileEntityMultiConduit)tile).lastPipes[finalI] = this;
                        if (intFluid.amount < extFluid.amount) {
                            this.take(extFluid, (Direction)side, finalI);
                        } else {
                            this.give((Direction)side, finalI, finalI);
                        }
                    }
                } else if (tile instanceof TileEntityFluidPipe && !tile.equals(this.lastPipes[finalI])) {
                    TileEntityFluidPipe inv = (TileEntityFluidPipe)tile;
                    int activeSlot = this.conduitConnections.get(side);
                    if (activeSlot == -1) {
                        return;
                    }
                    FluidStack intFluid = this.getFluidInSlot(activeSlot);
                    FluidStack extFluid = inv.getFluidInSlot(0);
                    if (intFluid != null && extFluid == null) {
                        this.lastPipes[finalI] = (TileEntityFluidPipe)tile;
                        ((TileEntityFluidPipe)tile).last = this;
                        this.give((Direction)side, activeSlot, 0);
                    } else if (intFluid == null && extFluid != null) {
                        this.lastPipes[finalI] = (TileEntityFluidPipe)tile;
                        ((TileEntityFluidPipe)tile).last = this;
                        this.take(extFluid, (Direction)side, activeSlot);
                    } else if (intFluid != null) {
                        this.lastPipes[finalI] = (TileEntityFluidPipe)tile;
                        ((TileEntityFluidPipe)tile).last = this;
                        if (intFluid.amount < extFluid.amount) {
                            this.take(extFluid, (Direction)side, activeSlot);
                        } else {
                            this.give((Direction)side, activeSlot, 0);
                        }
                    }
                }
            });
        }
    }

    public boolean addConduit(IConduitBlock newConduit) {
        for (int i = 0; i < this.conduits.length; ++i) {
            IConduitBlock conduit = this.conduits[i];
            if (newConduit.getConduitCapability() == ConduitCapability.RES_NETWORK && conduit != null && conduit.getConduitCapability() == ConduitCapability.RES_NETWORK) {
                return false;
            }
            if (conduit != null) continue;
            this.conduits[i] = newConduit;
            if (newConduit.getConduitCapability() == ConduitCapability.FLUID || newConduit.getConduitCapability() == ConduitCapability.SIGNALUM) {
                this.fluidContents = Arrays.copyOf(this.fluidContents, this.fluidContents.length + 1);
                this.fluidCapacity = Arrays.copyOf(this.fluidCapacity, this.fluidCapacity.length + 1);
                this.acceptedFluids.add(new ArrayList());
                if (newConduit instanceof ITiered) {
                    this.fluidCapacity[this.fluidCapacity.length - 1] = (int)Math.pow(2.0, ((ITiered)newConduit).getTier().ordinal()) * 1000;
                    int value = (int)Math.pow(2.0, ((ITiered)newConduit).getTier().ordinal()) * 20;
                    if (this.transferSpeed < value) {
                        this.transferSpeed = value;
                    }
                }
                if (newConduit.getConduitCapability() == ConduitCapability.FLUID) {
                    ((ArrayList)this.acceptedFluids.get(this.acceptedFluids.size() - 1)).addAll(Fluid.fluidMap.values());
                    ((ArrayList)this.acceptedFluids.get(this.acceptedFluids.size() - 1)).remove(SIFluids.ENERGY);
                } else if (newConduit.getConduitCapability() == ConduitCapability.SIGNALUM) {
                    ((ArrayList)this.acceptedFluids.get(this.acceptedFluids.size() - 1)).add(SIFluids.ENERGY);
                }
            } else {
                this.fluidContents = Arrays.copyOf(this.fluidContents, this.fluidContents.length + 1);
                this.fluidCapacity = Arrays.copyOf(this.fluidCapacity, this.fluidCapacity.length + 1);
                this.acceptedFluids.add(new ArrayList());
                this.fluidCapacity[this.fluidCapacity.length - 1] = 0;
            }
            return true;
        }
        return false;
    }

    public int getAmountOfConduits() {
        int n = 0;
        for (IConduitBlock conduit : this.conduits) {
            if (conduit == null) continue;
            ++n;
        }
        return n;
    }

    public int getActiveFluidSlotForSide(Direction dir) {
        return this.conduitConnections.get(dir);
    }

    public Connection getFluidIOForSide(Direction dir) {
        return Connection.BOTH;
    }

    public void writeToNBT(CompoundTag tag) {
        ListTag conduitList = new ListTag();
        CompoundTag conduitConnectionsTag = new CompoundTag();
        for (IConduitBlock conduit : this.conduits) {
            if (conduit == null) continue;
            BlockLogic block = (BlockLogic)conduit;
            conduitList.addTag((Tag)new IntTag(block.id()));
        }
        for (Map.Entry entry : this.conduitConnections.entrySet()) {
            Direction dir = (Direction)entry.getKey();
            int n = (Integer)entry.getValue();
            conduitConnectionsTag.putInt(String.valueOf(dir.ordinal()), n);
        }
        tag.putList("conduits", conduitList);
        tag.putCompound("conduitConnections", conduitConnectionsTag);
        CompoundTag coversNbt = new CompoundTag();
        for (Map.Entry<Direction, Multipart> entry : this.parts.entrySet()) {
            if (entry.getValue() == null) continue;
            CompoundTag partNbt = new CompoundTag();
            entry.getValue().writeToNbt(partNbt);
            coversNbt.putCompound(String.valueOf(entry.getKey().ordinal()), partNbt);
        }
        tag.putCompound("Parts", coversNbt);
        super.writeToNBT(tag);
    }

    public void readFromNBT(CompoundTag tag) {
        ListTag conduitList = tag.getList("conduits");
        conduitList.forEach(C -> this.addConduit((IConduitBlock)Blocks.getBlock((int)((Integer)C.getValue())).getLogic()));
        CompoundTag connectionsTag = tag.getCompound("conduitConnections");
        for (Object con : connectionsTag.getValues()) {
            this.conduitConnections.replace(Direction.values()[Integer.parseInt(((IntTag)con).getTagName())], (Integer)((IntTag)con).getValue());
        }
        CompoundTag coversNbt = tag.getCompound("Parts");
        for (Map.Entry entry : ((Map)coversNbt.getValue()).entrySet()) {
            Direction dir = Direction.values()[Integer.parseInt((String)entry.getKey())];
            CompoundTag partTag = (CompoundTag)entry.getValue();
            this.parts.put(dir, new Multipart(partTag));
        }
        super.readFromNBT(tag);
    }

    @Override
    public String getName() {
        Field field = ReflectUtils.getField(TileEntity.class, (String[])new String[]{"classToNameMap"});
        return (String)ReflectUtils.getValue((Field)field, null, String.class);
    }

    public boolean supports(ConduitCapability capability) {
        for (IConduitBlock conduit : this.conduits) {
            if (conduit == null || conduit.getConduitCapability() != capability) continue;
            return true;
        }
        return false;
    }

    public BlockInstance toInstance() {
        return new BlockInstance(Blocks.blocksList[this.worldObj.getBlockId(this.x, this.y, this.z)], new Vec3i(this.x, this.y, this.z), (TileEntity)this);
    }

    public void buttonClicked(int id, int button, int channel) {
        Direction dir;
        Integer currentValue;
        if (button == 0) {
            Direction dir2;
            Integer currentValue2;
            if (id > 5 && id < 12 && (currentValue2 = this.conduitConnections.get(dir2 = Direction.values()[id - 6])) < this.getAmountOfConduits() - 1) {
                this.conduitConnections.replace(dir2, currentValue2 + 1);
            }
        } else if (button == 1 && id > 5 && id < 12 && (currentValue = this.conduitConnections.get(dir = Direction.values()[Math.min(6, Math.max(0, id - 6))])) > -1) {
            this.conduitConnections.put(dir, currentValue - 1);
        }
    }

    public HashMap<Direction, Multipart> getParts() {
        return this.parts;
    }
}

