/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerCrafting;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;

public class TileEntityAssembler
extends TileEntityTieredMachineBase
implements IBoostable {
    public final AssemblerTemplate template = new AssemblerTemplate();
    public RecipeEntryCrafting<?, ItemStack> recipe;

    public TileEntityAssembler() {
        this.itemContents = new ItemStack[19];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 2000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
    }

    @Override
    public void tick() {
        super.tick();
        this.extractFluids();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.getBlock() != null && this.worldObj != null) {
            this.work();
        }
    }

    @Override
    public void applyModifiers() {
        super.applyModifiers();
        this.yield = 1.0f;
        if (this.speedMultiplier > 1.0f) {
            this.speedMultiplier *= 1.25f;
        }
    }

    private void work() {
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (!this.canProcess()) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)(90.0f / this.speedMultiplier);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess()) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public void processItem() {
        if (!this.canProcess()) {
            return;
        }
        if (this.recipe == null) {
            return;
        }
        ArrayList condensedInv = Catalyst.condenseItemList(Arrays.asList(this.itemContents));
        ArrayList recipeInputs = new ArrayList();
        if (this.recipe.getInput() instanceof RecipeSymbol[]) {
            recipeInputs = new ArrayList<RecipeSymbol>(Arrays.asList((RecipeSymbol[])this.recipe.getInput()));
        } else if (this.recipe.getInput() instanceof List) {
            recipeInputs = (ArrayList)this.recipe.getInput();
        }
        if (recipeInputs.isEmpty()) {
            return;
        }
        recipeInputs.removeIf(Objects::isNull);
        if (!SignalIndustries.hasItems(recipeInputs, condensedInv)) {
            return;
        }
        int s = 0;
        int sReq = (int)recipeInputs.stream().filter(Objects::nonNull).count();
        block0: for (RecipeSymbol symbol : recipeInputs) {
            for (ItemStack stack : this.itemContents) {
                if (!symbol.matches(stack) || stack == null || stack.stackSize <= 0) continue;
                --stack.stackSize;
                if (stack.getItem().hasContainerItem()) {
                    ItemStack container = new ItemStack(stack.getItem().getContainerItem());
                    boolean added = false;
                    for (int i = 1; i < this.itemContents.length; ++i) {
                        ItemStack content = this.itemContents[i];
                        if (content == null) {
                            this.setItem(i, container);
                            added = true;
                            break;
                        }
                        if (!content.isItemEqual(container) || content.stackSize >= content.getMaxStackSize()) continue;
                        ++this.itemContents[i].stackSize;
                        added = true;
                        break;
                    }
                    if (!added) {
                        EntityItem entityitem = new EntityItem(this.worldObj, (double)this.x, (double)((float)this.y + 1.0f), (double)this.z, container);
                        this.worldObj.entityJoinedWorld((Entity)entityitem);
                    }
                }
                ++s;
                continue block0;
            }
        }
        this.itemContents = (ItemStack[])Arrays.stream(this.itemContents).filter(S -> S == null || S.stackSize > 0).toArray(A -> new ItemStack[19]);
        if (s == sReq) {
            boolean multiplier = true;
            ItemStack output = ((ItemStack)this.recipe.getOutput()).copy();
            if (!(this.itemContents[0] == null || this.itemContents[0].isItemEqual(output) && this.itemContents[0].stackSize + output.stackSize * 1 <= this.itemContents[0].getMaxStackSize())) {
                return;
            }
            if (this.itemContents[0] == null) {
                output.stackSize *= 1;
                this.itemContents[0] = output;
            } else {
                this.itemContents[0].stackSize += output.stackSize * 1;
            }
        }
    }

    public boolean canProcess() {
        if (this.recipe == null) {
            return false;
        }
        boolean multiplier = true;
        ItemStack output = ((ItemStack)this.recipe.getOutput()).copy();
        if (!(this.itemContents[0] == null || this.itemContents[0].isItemEqual(output) && this.itemContents[0].stackSize + output.stackSize * 1 <= this.itemContents[0].getMaxStackSize())) {
            return false;
        }
        ArrayList condensedInv = Catalyst.condenseItemList(Arrays.asList(this.itemContents));
        ArrayList recipeInputs = new ArrayList();
        if (this.recipe.getInput() instanceof RecipeSymbol[]) {
            recipeInputs = new ArrayList<RecipeSymbol>(Arrays.asList((RecipeSymbol[])this.recipe.getInput()));
        } else if (this.recipe.getInput() instanceof List) {
            recipeInputs = (ArrayList)this.recipe.getInput();
        }
        if (recipeInputs.isEmpty()) {
            return false;
        }
        recipeInputs.removeIf(Objects::isNull);
        return SignalIndustries.hasItems(recipeInputs, condensedInv);
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.recipe != null && this.fluidContents[0].amount >= 100) {
            this.progressMaxTicks = (int)(90.0f / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= 100;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag templateTag = new CompoundTag();
        this.template.writeToNBT(templateTag);
        tag.put("Template", (Tag)templateTag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.template.readFromNBT(tag.getCompound("Template"));
        this.template.setChanged();
    }

    public int getActiveItemSlotForSide(Direction dir, ItemStack stack) {
        if ((Integer)this.activeItemSlots.get(dir) == -1 && this.itemConnections.get(dir) == Connection.INPUT) {
            for (int i = 1; i < this.itemContents.length; ++i) {
                ItemStack content = this.itemContents[i];
                if (content != null && (!content.isItemEqual(stack) || content.stackSize + stack.stackSize > content.getMaxStackSize())) continue;
                return i;
            }
        }
        return super.getActiveItemSlotForSide(dir, stack);
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.assembler";
    }

    public class AssemblerTemplate
    extends ContainerCrafting
    implements Container {
        public ItemStack[] itemContents;

        public AssemblerTemplate() {
            super(null, 3, 3);
            this.itemContents = new ItemStack[9];
        }

        public int getContainerSize() {
            return this.itemContents.length;
        }

        public ItemStack getItem(int i1) {
            return this.itemContents[i1];
        }

        public ItemStack removeItem(int i1, int i2) {
            if (this.itemContents[i1] != null) {
                if (this.itemContents[i1].stackSize <= i2) {
                    ItemStack itemStack3 = this.itemContents[i1];
                    this.itemContents[i1] = null;
                    this.setChanged();
                    return itemStack3;
                }
                ItemStack itemStack3 = this.itemContents[i1].splitStack(i2);
                if (this.itemContents[i1].stackSize == 0) {
                    this.itemContents[i1] = null;
                }
                this.setChanged();
                return itemStack3;
            }
            return null;
        }

        public void setItem(int i1, ItemStack itemStack2) {
            this.itemContents[i1] = itemStack2;
            if (itemStack2 != null && itemStack2.stackSize > this.getMaxStackSize()) {
                itemStack2.stackSize = this.getMaxStackSize();
            }
            this.setChanged();
        }

        public void readFromNBT(CompoundTag CompoundTag1) {
            ListTag nBTTagList2 = CompoundTag1.getList("Items");
            this.itemContents = new ItemStack[this.getContainerSize()];
            for (int i3 = 0; i3 < nBTTagList2.tagCount(); ++i3) {
                CompoundTag CompoundTag4 = (CompoundTag)nBTTagList2.tagAt(i3);
                int i5 = CompoundTag4.getByte("Slot") & 0xFF;
                if (i5 < 0 || i5 >= this.itemContents.length) continue;
                this.itemContents[i5] = ItemStack.readItemStackFromNbt((CompoundTag)CompoundTag4);
            }
        }

        public void writeToNBT(CompoundTag CompoundTag1) {
            ListTag nbtTagList = new ListTag();
            for (int i3 = 0; i3 < this.itemContents.length; ++i3) {
                if (this.itemContents[i3] == null) continue;
                CompoundTag CompoundTag4 = new CompoundTag();
                CompoundTag4.putByte("Slot", (byte)i3);
                this.itemContents[i3].writeToNBT(CompoundTag4);
                nbtTagList.addTag((Tag)CompoundTag4);
            }
            CompoundTag1.put("Items", (Tag)nbtTagList);
        }

        public int getMaxStackSize() {
            return 64;
        }

        public void setChanged() {
            TileEntityAssembler.this.recipe = this.findMatchingRecipe(this);
        }

        public boolean stillValid(Player entityPlayer1) {
            return true;
        }

        public RecipeEntryCrafting<?, ItemStack> findMatchingRecipe(AssemblerTemplate template) {
            for (int i = 0; i < Registries.RECIPES.getAllCraftingRecipes().size(); ++i) {
                RecipeEntryCrafting recipe = (RecipeEntryCrafting)Registries.RECIPES.getAllCraftingRecipes().get(i);
                if (!recipe.matches((ContainerCrafting)template) || recipe instanceof RecipeEntryCraftingDynamic) continue;
                return recipe;
            }
            return null;
        }
    }
}

