/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.recipes.RecipeGroupSI;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.MeteorLocation;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class TileEntityCollector
extends TileEntityTieredMachineBase
implements IBoostable {
    public RecipeGroupSI<?> recipeGroup;
    public RecipeEntrySI<?, ?, RecipeProperties> currentRecipe;
    public int recipeId = 0;
    public boolean enhanced = false;
    public int[] itemInputs = new int[]{0};
    public int[] fluidOutputs = new int[]{0};
    public Random random = new Random();

    public TileEntityCollector() {
        this.itemContents = new ItemStack[1];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 4000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.fuelMaxBurnTicks = 1;
        this.recipeGroup = SIRecipes.COLLECTOR;
    }

    public void work() {
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.areAllInputsNull()) {
            this.progressTicks = 0;
            this.fuelBurnTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
            this.fuelBurnTicks = 1;
        }
        if (!this.worldObj.isClientSide && this.isBurning() && this.canProcess()) {
            ++this.progressTicks;
            if (this.progressTicks >= this.progressMaxTicks) {
                this.progressTicks = 0;
                this.processItem();
                update = true;
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public void processItem() {
        if (this.canProcess() && this.currentRecipe instanceof RecipeEntryMachineFluid) {
            FluidStack fluidStack;
            RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
            FluidStack fluidStack2 = fluidStack = recipe.getOutput() == null ? null : ((FluidStack)recipe.getOutput()).copy();
            if (fluidStack != null && this.random.nextFloat() <= ((RecipeProperties)recipe.getData()).chance) {
                int multiplier = 1;
                float fraction = Float.parseFloat("0." + String.valueOf(this.yield).split("\\.")[1]);
                if (fraction <= 0.0f) {
                    fraction = 1.0f;
                }
                if (this.yield > 1.0f && this.random.nextFloat() <= fraction) {
                    multiplier = (int)Math.ceil(this.yield);
                }
                if (this.fluidContents[this.fluidOutputs[0]] == null) {
                    fluidStack.amount *= multiplier;
                    this.setFluidInSlot(this.fluidOutputs[0], fluidStack);
                } else if (this.fluidContents[this.fluidOutputs[0]].isFluidEqual(fluidStack)) {
                    this.fluidContents[this.fluidOutputs[0]].amount += fluidStack.amount * multiplier;
                }
            }
        }
    }

    public boolean canProcess() {
        if (this.currentRecipe instanceof RecipeEntryMachineFluid) {
            if (!this.worldObj.canExistingBlockSeeTheSky(this.x, this.y, this.z)) {
                return false;
            }
            RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
            FluidStack fluidStack = (FluidStack)recipe.getOutput();
            if (fluidStack == null) {
                return false;
            }
            return this.areFluidOutputsValid(fluidStack);
        }
        return false;
    }

    public boolean areFluidOutputsValid(FluidStack stack) {
        for (int fluidOutput : this.fluidOutputs) {
            FluidStack outputStack = this.getFluidInSlot(fluidOutput);
            if (outputStack == null) continue;
            if (outputStack.isFluidEqual(stack)) {
                if (!(this.yield > 1.0f ? (double)stack.amount * Math.ceil(this.yield) > (double)this.getRemainingCapacity(fluidOutput) : stack.amount > this.getRemainingCapacity(fluidOutput))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean areAllInputsNull() {
        return Arrays.stream(this.itemInputs).allMatch(slot -> this.itemContents[slot] == null);
    }

    public void setCurrentRecipe() {
        ArrayList symbols = new ArrayList();
        Arrays.stream(this.itemInputs).forEach(id -> {
            if (this.getItem(id) != null) {
                symbols.add(new RecipeExtendedSymbol(this.getItem(id)));
            }
        });
        this.currentRecipe = this.recipeGroup.findRecipe(symbols.toArray(new RecipeExtendedSymbol[0]), this.tier, this.recipeId);
    }

    @Override
    public void tick() {
        super.tick();
        this.extractFluids();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.getBlock() != null) {
            this.setCurrentRecipe();
            if (!this.disabled) {
                this.work();
            }
            if (!this.enhanced) {
                double distance = 24.0;
                for (MeteorLocation meteorLocation : SignalIndustries.meteorLocations) {
                    Vec3i location = meteorLocation.location;
                    if (!(location.getSqDistanceTo(this.x, this.y, this.z) < distance) || meteorLocation.type != MeteorLocation.Type.SIGNALUM) continue;
                    this.enhanced = true;
                }
            }
        }
    }

    @Override
    public void applyModifiers() {
        super.applyModifiers();
        this.yield = this.enhanced ? 2.0f : 1.0f;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.collector";
    }
}

