/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.entities.EntityRealityTear;
import sunsetsatellite.signalindustries.entities.EntityShockwave;
import sunsetsatellite.signalindustries.items.ItemWarpOrb;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;

public class TileEntityPulsar
extends TileEntityTieredMachineBase {
    public float orbRotation = 0.0f;
    public boolean charging = false;

    public TileEntityPulsar() {
        this.itemContents = new ItemStack[1];
        this.fluidCapacity[0] = 32000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.fuelMaxBurnTicks = 100;
    }

    @Override
    public void tick() {
        super.tick();
        this.orbRotation = this.orbRotation < 360.0f ? (this.orbRotation += 0.1f) : 0.0f;
        if (this.charging && this.progressTicks < this.progressMaxTicks && this.fluidContents[0] != null && this.fluidContents[0].amount >= 30) {
            ++this.progressTicks;
            this.fluidContents[0].amount = this.getItem(0) != null && this.getItem(0).getItem() instanceof ItemWarpOrb ? (this.fluidContents[0].amount -= 40) : (this.fluidContents[0].amount -= 20);
        }
        if (this.fuelBurnTicks > 0) {
            this.charging = false;
            this.progressTicks = 0;
            --this.fuelBurnTicks;
        }
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.pulsarBlock";
    }

    public void activate() {
        if (this.charging && this.progressTicks >= this.progressMaxTicks) {
            this.charging = false;
            this.progressTicks = 0;
            this.fuelBurnTicks = this.fuelMaxBurnTicks;
            if (this.worldObj != null && this.getItem(0) != null && this.getItem(0).getItem() instanceof ItemWarpOrb) {
                EntityRealityTear tear = new EntityRealityTear(this.worldObj, this.getPosition(), this.getItem(0));
                this.worldObj.entityJoinedWorld((Entity)tear);
                this.setItem(0, null);
            } else if (this.worldObj != null) {
                EntityShockwave s = new EntityShockwave(this.worldObj, this.getPosition());
                this.worldObj.entityJoinedWorld((Entity)s);
            }
        } else if (this.fuelBurnTicks <= 0 && this.fluidContents[0] != null && this.getItem(0) == null && this.fluidContents[0].amount >= 4000 || this.getItem(0) != null && this.getItem(0).getItem() instanceof ItemWarpOrb && this.fluidContents[0].amount >= 8000) {
            this.charging = true;
        }
    }

    @Override
    public boolean isBurning() {
        return this.progressTicks > 0;
    }

    public boolean locked(int index) {
        return this.isBurning();
    }
}

