/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.glacial_block;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GlacialBlockEntity
extends LivingEntity
implements GeoEntity,
PreventDismount,
AntiMagicSusceptible {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int duration;
    private boolean playSound = true;
    private LivingEntity target;

    public float m_6134_() {
        return this.target == null ? 1.0f : this.target.m_6134_();
    }

    public GlacialBlockEntity(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public GlacialBlockEntity(Level level, LivingEntity owner) {
        this((EntityType<? extends LivingEntity>)((EntityType)CSEntityRegistry.GLACIAL_BLOCK.get()), level);
        this.setOwner(owner);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public boolean m_275843_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        Entity frozen = this.m_146895_();
        if (frozen != null) {
            return EntityDimensions.m_20398_((float)(frozen.m_20205_() * 1.25f), (float)0.75f);
        }
        return super.m_6972_(pPose);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.playSound) {
            this.m_6210_();
            this.m_5496_((SoundEvent)SoundRegistry.ICE_BLOCK_CAST.get(), 2.0f, 1.0f);
            this.playSound = false;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ > this.duration || this.target != null && this.target.m_21224_() || !this.m_20160_()) {
                this.removeGlacialBlock();
            } else if (this.f_19797_ > 20 && this.target != null) {
                DamageSources.applyDamage((Entity)this.target, (float)5.0f, (DamageSource)((AbstractSpell)SpellRegistries.CRYOPIERCER.get()).getDamageSource((Entity)this, (Entity)this.getOwner()));
            }
        }
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void removeGlacialBlock() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_(ParticleHelper.SNOWFLAKE, this.m_20185_() + Utils.getRandomScaled((double)0.1f), this.m_20186_() + Utils.getRandomScaled((double)0.1f), this.m_20189_() + Utils.getRandomScaled((double)0.1f), Utils.getRandomScaled((double)2.0), (double)(-this.f_19796_.m_188501_() * 0.5f), Utils.getRandomScaled((double)2.0));
            }
        }
        List entities = this.m_20197_();
        for (Entity entity : entities) {
            DamageSources.applyDamage((Entity)entity, (float)15.0f, (DamageSource)((AbstractSpell)SpellRegistries.CRYOPIERCER.get()).getDamageSource((Entity)this, (Entity)this.getOwner()));
        }
        this.m_20153_();
        this.m_146870_();
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public boolean m_20367_(Entity pEntity) {
        return true;
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.removeGlacialBlock();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_21275_(DamageSource pDamageSource) {
        return true;
    }

    public boolean m_20152_() {
        return false;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        int x = (int)(this.m_20185_() - pPassenger.m_20185_());
        int y = (int)(this.m_20186_() - pPassenger.m_20186_());
        int z = (int)(this.m_20189_() - pPassenger.m_20189_());
        if ((x *= x) + (y *= y) + (z *= z) > 25) {
            this.removeGlacialBlock();
        } else {
            pPassenger.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            this.removeGlacialBlock();
            return true;
        }
        return false;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.singleton(ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.f_19797_);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128405_("Duration", this.duration);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19797_ = pCompound.m_128451_("Age");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        this.duration = pCompound.m_128451_("Duration");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

