/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.registries;

import io.redspace.ironsspellbooks.api.attribute.MagicRangedAttribute;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="cataclysm_spellbooks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CSAttributeRegistry {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"cataclysm_spellbooks");
    public static final RegistryObject<Attribute> ABYSSAL_MAGIC_RESIST = CSAttributeRegistry.registerResistanceAttribute("abyssal");
    public static final RegistryObject<Attribute> ABYSSAL_MAGIC_POWER = CSAttributeRegistry.registerPowerAttribute("abyssal");
    public static final RegistryObject<Attribute> TECHNOMANCY_MAGIC_RESIST = CSAttributeRegistry.registerResistanceAttribute("technomancy");
    public static final RegistryObject<Attribute> TECHNOMANCY_MAGIC_POWER = CSAttributeRegistry.registerPowerAttribute("technomancy");

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().forEach(entity -> ATTRIBUTES.getEntries().forEach(attribute -> event.add(entity, (Attribute)attribute.get())));
    }

    private static RegistryObject<Attribute> registerResistanceAttribute(String id) {
        return ATTRIBUTES.register(id + "_magic_resist", () -> new MagicRangedAttribute("attribute.cataclysm_spellbooks." + id + "_magic_resist", 1.0, 0.0, 10.0).m_22084_(true));
    }

    private static RegistryObject<Attribute> registerPowerAttribute(String id) {
        return ATTRIBUTES.register(id + "_spell_power", () -> new MagicRangedAttribute("attribute.cataclysm_spellbooks." + id + "_spell_power", 1.0, 0.0, 10.0).m_22084_(true));
    }

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }
}

