/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.blood;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.final_rend.FinalRendAoE;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSAttributeRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSoundRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class FinalRendSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "final_rend");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(CSSchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(45.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.stringTruncation((double)this.getEffectDuration(spellLevel, caster), (int)1)}));
    }

    public FinalRendSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 25;
        this.spellPowerPerLevel = 1;
        this.castTime = 70;
        this.baseManaCost = 150;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_POWERFUL_SWORD_SLASH;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.SHOCKWAVE_PREPARE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)CSSoundRegistry.ELECTRIC_SWORD_SWING.get());
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.IMMUNITY_EFFECT.get(), this.getCastTime(spellLevel), 0, false, false, false));
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        if (entity.f_19797_ % 10 == 0) {
            int count = 16;
            float particleRadius = 1.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius;
                double z = Math.sin(theta) * (double)particleRadius;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.SPARK.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count2 = 16;
            float particleRadius2 = 3.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count2) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius2;
                double z = Math.sin(theta) * (double)particleRadius2;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.SPARK.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count3 = 16;
            float particleRadius3 = 5.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count3) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius3;
                double z = Math.sin(theta) * (double)particleRadius3;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.SPARK.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 3.25f;
        float distance = 2.15f;
        Vec3 hitLocation = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.3f), 0.0).m_82549_(entity.m_20156_().m_82542_((double)distance, (double)0.35f, (double)distance));
        List entities = entity.m_9236_().m_45933_((Entity)entity, AABB.m_165882_((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (!entity.m_6087_() || !(entity.m_20280_(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.m_146892_(), (Vec3)target.m_20191_().m_82399_(), (boolean)true) || !DamageSources.applyDamage((Entity)target, (float)(this.getDamage(spellLevel, entity) + this.getBonusDamage(spellLevel, entity)), (DamageSource)this.getDamageSource((Entity)entity))) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.BLOOD, (double)target.m_20185_(), (double)(target.m_20186_() + (double)(target.m_20206_() * 0.5f)), (double)target.m_20189_(), (int)50, (double)(target.m_20205_() * 0.5f), (double)(target.m_20206_() * 0.5f), (double)(target.m_20205_() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.m_44896_((LivingEntity)entity, (Entity)target);
        }
        boolean mirrored = false;
        SpellSelectionManager.SelectionOption selection = new SpellSelectionManager((Player)entity).getSelection();
        new SpellSelectionManager((Player)entity).getSelection();
        if (selection != null) {
            mirrored = selection.slot.equals(SpellSelectionManager.OFFHAND);
        }
        FinalRendAoE swipe = new FinalRendAoE(level, mirrored);
        swipe.m_20219_(hitLocation);
        swipe.m_146922_(entity.m_146908_());
        swipe.setEffectDuration(this.getEffectDuration(spellLevel, entity));
        swipe.setEffectAmplifier(spellLevel);
        level.m_7967_((Entity)swipe);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)6.0f, (float)0.08f, (int)20, (int)20);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setIFrames(0).setLifestealPercent(1.0f);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        float damage = CSUtils.getDamageForAttributes(this, entity, spellLevel, (Attribute)CSAttributeRegistry.TECHNOMANCY_MAGIC_POWER.get(), 1.0f);
        return damage * 1.5f + Utils.getWeaponDamage((LivingEntity)entity, (MobType)MobType.f_21640_);
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        return this.getRecastCount(spellLevel, caster);
    }

    private float getEffectDuration(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster, (MobType)MobType.f_21640_);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }
}

