/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.spells.TargetedTargetAreaCastData;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy.AbstractHarbingerSpell;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class IntrusionPreventionSystemSpell
extends AbstractHarbingerSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "intrusion_prevention_system");
    private static final int MAX_TARGETS = 8;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(1).setCooldownSeconds(260.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.max_victims", (Object[])new Object[]{8}));
    }

    public IntrusionPreventionSystemSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 1;
        this.castTime = 15;
        this.baseManaCost = 150;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (!Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f, (boolean)false)) {
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(entity));
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success_self", (Object[])new Object[]{this.getDisplayName((Player)player)}).m_130940_(ChatFormatting.GREEN)));
            }
        }
        float radius = this.getRadius(spellLevel, entity);
        LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
        TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)target.m_20182_(), (float)radius, (int)Utils.packRGB((Vector3f)this.getTargetingColor()), (Entity)target);
        playerMagicData.setAdditionalCastData((ICastData)new TargetedTargetAreaCastData(target, area));
        return true;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetedTargetAreaCastData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetedTargetAreaCastData && (targetEntity = (targetData = (TargetedTargetAreaCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float radius = this.getRadius(spellLevel, entity);
            AtomicInteger targets = new AtomicInteger(0);
            targetEntity.m_9236_().m_45976_(LivingEntity.class, targetEntity.m_20191_().m_82400_((double)radius)).forEach(victim -> {
                if (targets.get() < 8 && victim instanceof MagicSummon && victim.m_20280_((Entity)targetEntity) < (double)(radius * radius)) {
                    victim.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.IPS_POTION_EFFECT.get(), this.getDuration(spellLevel, entity), 0));
                    targets.incrementAndGet();
                }
            });
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.IPS_POTION_EFFECT.get(), this.getDuration(spellLevel, entity), 0));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }

    private float getRadius(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 2.0f;
    }
}

