/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.nature;

import com.github.L_Ender.cataclysm.entity.projectile.Ancient_Desert_Stele_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class MonolithCrashSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "monolith_crash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(8).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.windmill_rings", (Object[])new Object[]{spellLevel}), Component.m_237110_((String)"ui.cataclysm_spellbooks.windmill_amount", (Object[])new Object[]{Utils.stringTruncation((double)this.getSpellPower(spellLevel, (Entity)caster), (int)0)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}));
    }

    public MonolithCrashSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.spawnMonolithWindmill(spellLevel, (int)this.getSpellPower(spellLevel, (Entity)entity), 2.0, 0.75, 0.6, entity.m_20186_(), 1, entity, level, this.getDamage(spellLevel, entity));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnMonolithWindmill(int numofBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, double spawnY, int delay, LivingEntity caster, Level level, float damage) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numofBranches);
        for (int branch = 0; branch < numofBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)i * curveFactor);
                double offsetX = currentRadius * Math.cos(currentAngle);
                double offsetZ = currentRadius * Math.sin(currentAngle);
                double spawnX = caster.m_20185_() + offsetX;
                double spawnZ = caster.m_20189_() + offsetZ;
                int d1 = delay * (i + 1);
                this.spawnMonoliths(spawnX, spawnY, spawnZ, currentAngle, d1, caster, level, damage);
            }
        }
    }

    private void spawnMonoliths(double x, double y, double z, float rotation, int delay, LivingEntity caster, Level level, float damage) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape shape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.m_8055_(pos1 = pos.m_7494_())).m_60783_((BlockGetter)level, pos1, Direction.DOWN)) continue;
            if (level.m_46859_(pos) || (shape = (blockState1 = level.m_8055_(pos)).m_60812_((BlockGetter)level, pos)).m_83281_()) break;
            d0 = shape.m_83297_(Direction.Axis.Y);
            break;
        } while ((pos = pos.m_7494_()).m_123342_() < Math.min(level.m_151558_(), caster.m_146904_() + 10));
        Ancient_Desert_Stele_Entity monolith = new Ancient_Desert_Stele_Entity(level, x, (double)pos.m_123342_() + d0 - 3.0, z, rotation, delay, damage, caster);
        level.m_7967_((Entity)monolith);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }
}

