/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.entity;

import dev.muon.medievalorigins.entity.SummonedMob;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;

public class SummonTracker {
    private static final Map<UUID, Set<SummonedMob>> OWNER_TO_SUMMONS = new ConcurrentHashMap<UUID, Set<SummonedMob>>();
    private static int cleanupTicks = 0;
    private static final int CLEANUP_INTERVAL = 200;

    public static void init() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof SummonedMob) {
                SummonedMob summon = (SummonedMob)entity;
                SummonTracker.trackSummon(summon);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++cleanupTicks >= 200) {
                cleanupTicks = 0;
                SummonTracker.cleanupInvalidSummons();
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> OWNER_TO_SUMMONS.clear());
    }

    public static void trackSummon(SummonedMob summon) {
        UUID ownerID = summon.method_6139();
        if (ownerID != null) {
            OWNER_TO_SUMMONS.computeIfAbsent(ownerID, k -> ConcurrentHashMap.newKeySet()).add(summon);
        }
    }

    public static void untrackSummon(SummonedMob summon) {
        Set<SummonedMob> summons;
        UUID ownerID = summon.method_6139();
        if (ownerID != null && (summons = OWNER_TO_SUMMONS.get(ownerID)) != null) {
            summons.remove(summon);
            if (summons.isEmpty()) {
                OWNER_TO_SUMMONS.remove(ownerID);
            }
        }
    }

    public static Collection<SummonedMob> getSummonsForOwner(UUID ownerID) {
        return OWNER_TO_SUMMONS.getOrDefault(ownerID, Collections.emptySet());
    }

    public static void cleanupInvalidSummons() {
        OWNER_TO_SUMMONS.values().forEach(summons -> summons.removeIf(summon -> !summon.getSelfAsMob().method_5805() || summon.method_6139() == null));
    }
}

