/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin.compat.icarus;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.muon.medievalorigins.power.IcarusWingsPowerType;
import dev.muon.medievalorigins.util.PowerCache;
import io.github.apace100.apoli.power.type.PowerType;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={IcarusHelper.class})
public abstract class IcarusHelperMixin {
    @ModifyReturnValue(method={"getConfigValues"}, at={@At(value="RETURN")})
    private static IcarusPlayerValues modifyConfigValues(final IcarusPlayerValues original, class_1309 entity) {
        Optional<IcarusWingsPowerType> icarusWings = PowerCache.getFirstPowerType((class_1297)entity, IcarusWingsPowerType.class, PowerType::isActive);
        if (icarusWings.isEmpty()) {
            return original;
        }
        return new IcarusPlayerValues(){

            public float wingsSpeed() {
                return original.wingsSpeed();
            }

            public float maxSlowedMultiplier() {
                return original.maxSlowedMultiplier();
            }

            public boolean armorSlows() {
                return original.armorSlows();
            }

            public boolean canLoopDeLoop() {
                return original.canLoopDeLoop();
            }

            public boolean canSlowFall() {
                return original.canSlowFall();
            }

            public float exhaustionAmount() {
                return original.exhaustionAmount() / 4.0f;
            }

            public int maxHeightAboveWorld() {
                return original.maxHeightAboveWorld();
            }

            public boolean maxHeightEnabled() {
                return original.maxHeightEnabled();
            }

            public float requiredFoodAmount() {
                return 0.0f;
            }
        };
    }

    @WrapOperation(method={"hasWings"}, at={@At(value="INVOKE", target="Ljava/util/function/Predicate;test(Ljava/lang/Object;)Z")})
    private static boolean hasWingsFromOrigin(Predicate<class_1309> instance, Object entity, Operation<Boolean> original) {
        return PowerCache.hasPowerType((class_1297)((class_1309)entity), IcarusWingsPowerType.class) || (Boolean)original.call(new Object[]{instance, entity}) != false;
    }

    @WrapOperation(method={"getEquippedWings"}, at={@At(value="INVOKE", target="Ljava/util/function/Function;apply(Ljava/lang/Object;)Ljava/lang/Object;")})
    private static Object getOriginWings(Function<class_1309, class_1799> instance, Object entity, Operation<class_1799> original) {
        if (PowerCache.hasPowerType((class_1297)((class_1309)entity), IcarusWingsPowerType.class)) {
            return null;
        }
        return original.call(new Object[]{instance, entity});
    }
}

