/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.util;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.type.PowerType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.minecraft.class_1297;

public class PowerCache {
    private static final Map<Integer, EntityCacheEntry> cache = new ConcurrentHashMap<Integer, EntityCacheEntry>();
    private static final AtomicLong tickCounter = new AtomicLong(0L);
    private static final int CLEANUP_INTERVAL = 600;
    private static final long MAX_AGE_TICKS = 6000L;

    public static <T extends PowerType> List<T> getPowerTypes(class_1297 entity, Class<T> powerClass) {
        if (entity == null || entity.method_31481()) {
            return Collections.emptyList();
        }
        EntityCacheEntry entry = PowerCache.getOrCreateEntityEntry(entity);
        CachedPowerData cached = entry.powerDataMap.computeIfAbsent(powerClass, pc -> {
            List powerTypes;
            return new CachedPowerData(powerTypes, !(powerTypes = PowerHolderComponent.getPowerTypes((class_1297)entity, (Class)powerClass)).isEmpty());
        });
        return cached.powerTypes;
    }

    public static <T extends PowerType> boolean hasPowerType(class_1297 entity, Class<T> powerClass) {
        if (entity == null || entity.method_31481()) {
            return false;
        }
        EntityCacheEntry entry = PowerCache.getOrCreateEntityEntry(entity);
        CachedPowerData<?> cached = entry.powerDataMap.get(powerClass);
        if (cached != null) {
            return cached.hasAny;
        }
        CachedPowerData newlyCached = entry.powerDataMap.computeIfAbsent(powerClass, pc -> {
            List powerTypes;
            return new CachedPowerData(powerTypes, !(powerTypes = PowerHolderComponent.getPowerTypes((class_1297)entity, (Class)powerClass)).isEmpty());
        });
        return newlyCached.hasAny;
    }

    public static <T extends PowerType> boolean hasPowerType(class_1297 entity, Class<T> powerClass, Predicate<T> filter) {
        if (entity == null || entity.method_31481()) {
            return false;
        }
        List<T> powerTypes = PowerCache.getPowerTypes(entity, powerClass);
        return powerTypes.stream().anyMatch(filter);
    }

    public static <T extends PowerType> Optional<T> getFirstPowerType(class_1297 entity, Class<T> powerClass, Predicate<T> filter) {
        if (entity == null || entity.method_31481()) {
            return Optional.empty();
        }
        List<T> powerTypes = PowerCache.getPowerTypes(entity, powerClass);
        return powerTypes.stream().filter(filter).findFirst();
    }

    private static EntityCacheEntry getOrCreateEntityEntry(class_1297 entity) {
        int entityId = entity.method_5628();
        UUID entityUuid = entity.method_5667();
        return cache.compute(entityId, (id, existing) -> {
            if (existing == null || !existing.entityUuid.equals(entityUuid)) {
                return new EntityCacheEntry(entityUuid);
            }
            existing.lastAccessTick = tickCounter.get();
            return existing;
        });
    }

    public static void invalidate(class_1297 entity) {
        if (entity == null) {
            return;
        }
        cache.remove(entity.method_5628());
    }

    public static void invalidate(class_1297 entity, Class<? extends PowerType> powerClass) {
        if (entity == null) {
            return;
        }
        int entityId = entity.method_5628();
        UUID entityUuid = entity.method_5667();
        cache.computeIfPresent(entityId, (id, existing) -> {
            if (existing.entityUuid.equals(entityUuid)) {
                existing.powerDataMap.remove(powerClass);
                return existing.powerDataMap.isEmpty() ? null : existing;
            }
            return existing;
        });
    }

    public static void clearAll() {
        cache.clear();
        tickCounter.set(0L);
    }

    public static void tick() {
        tickCounter.incrementAndGet();
        if (tickCounter.get() % 600L == 0L) {
            PowerCache.cleanupStaleEntries();
        }
    }

    private static void cleanupStaleEntries() {
        long cutoffTick = tickCounter.get() - 6000L;
        cache.entrySet().removeIf(entry -> ((EntityCacheEntry)entry.getValue()).lastAccessTick < cutoffTick);
    }

    public static CacheStats getStats() {
        int totalEntries = cache.size();
        int totalPowerTypes = cache.values().stream().mapToInt(entry -> entry.powerDataMap.size()).sum();
        return new CacheStats(totalEntries, totalPowerTypes, tickCounter.get());
    }

    private static class EntityCacheEntry {
        final Map<Class<?>, CachedPowerData<?>> powerDataMap = new ConcurrentHashMap();
        volatile long lastAccessTick;
        final UUID entityUuid;

        EntityCacheEntry(UUID entityUuid) {
            this.entityUuid = entityUuid;
            this.lastAccessTick = tickCounter.get();
        }
    }

    private static class CachedPowerData<T extends PowerType> {
        final List<T> powerTypes;
        final boolean hasAny;

        CachedPowerData(List<T> powerTypes, boolean hasAny) {
            this.powerTypes = Collections.unmodifiableList(new ArrayList<T>(powerTypes));
            this.hasAny = hasAny;
        }
    }

    public record CacheStats(int cachedEntities, int cachedPowerTypes, long currentTick) {
    }
}

