/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3545;

public class TransferItemAction {
    private static final double MAX_INTERACTION_DISTANCE = 6.0;

    public static ActionFactory<class_3545<class_1297, class_1297>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("transfer_item"), new SerializableData().add("source_slot", SerializableDataTypes.EQUIPMENT_SLOT, (Object)class_1304.field_6173).add("target_slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("prioritize_mainhand_for_take", SerializableDataTypes.BOOLEAN, (Object)false).add("allow_empty_hand_mainhand_take", SerializableDataTypes.BOOLEAN, (Object)false), TransferItemAction::action);
    }

    public static void action(SerializableData.Instance data, class_3545<class_1297, class_1297> entities) {
        class_1309 livingActor;
        class_1297 target;
        block7: {
            block6: {
                class_1297 actor = (class_1297)entities.method_15442();
                target = (class_1297)entities.method_15441();
                if (actor.method_37908().method_8608()) {
                    return;
                }
                if (!(actor instanceof class_1309)) break block6;
                livingActor = (class_1309)actor;
                if (target instanceof class_1309) break block7;
            }
            return;
        }
        class_1309 livingTarget = (class_1309)target;
        class_1304 sourceSlot = (class_1304)data.get("source_slot");
        class_1304 targetSlot = (class_1304)data.get("target_slot");
        boolean prioritizeMainhandForTake = (Boolean)data.get("prioritize_mainhand_for_take");
        boolean allowEmptyHandMainhandTake = (Boolean)data.get("allow_empty_hand_mainhand_take");
        class_243 eyePosition = livingActor.method_33571();
        class_243 lookVector = livingActor.method_5720();
        class_238 targetBoundingBox = livingTarget.method_5829();
        Optional clipResult = targetBoundingBox.method_992(eyePosition, eyePosition.method_1019(lookVector.method_1021(6.0)));
        class_243 hitVec = clipResult.orElse(null);
        class_1799 playerItemInSourceSlot = livingActor.method_6118(sourceSlot).method_7972();
        if (playerItemInSourceSlot.method_7960()) {
            TransferItemAction.handleTakingItem(livingActor, livingTarget, hitVec, sourceSlot, prioritizeMainhandForTake, allowEmptyHandMainhandTake);
        } else {
            TransferItemAction.handleGivingOrSwappingItem(livingActor, livingTarget, playerItemInSourceSlot, hitVec, sourceSlot, targetSlot);
        }
    }

    private static void handleTakingItem(class_1309 livingActor, class_1309 livingTarget, class_243 hitVec, class_1304 sourceSlot, boolean prioritizeMainhandForTake, boolean allowEmptyHandMainhandTake) {
        class_1304 slotOnSummonToInteract = null;
        if (prioritizeMainhandForTake) {
            if (!livingTarget.method_6118(class_1304.field_6173).method_7960()) {
                slotOnSummonToInteract = class_1304.field_6173;
            } else if (hitVec != null) {
                slotOnSummonToInteract = TransferItemAction.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
        } else {
            if (hitVec != null) {
                slotOnSummonToInteract = TransferItemAction.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
            if (slotOnSummonToInteract == null && !livingTarget.method_6118(class_1304.field_6173).method_7960()) {
                slotOnSummonToInteract = class_1304.field_6173;
            }
        }
        if (slotOnSummonToInteract != null) {
            if (slotOnSummonToInteract == class_1304.field_6173 && !allowEmptyHandMainhandTake) {
                return;
            }
            class_1799 summonItemInClickedSlot = livingTarget.method_6118(slotOnSummonToInteract).method_7972();
            if (!summonItemInClickedSlot.method_7960()) {
                livingActor.method_5673(sourceSlot, summonItemInClickedSlot);
                livingTarget.method_5673(slotOnSummonToInteract, class_1799.field_8037);
                if (livingTarget instanceof ISummon) {
                    ISummon summon = (ISummon)livingTarget;
                    if (slotOnSummonToInteract == class_1304.field_6173) {
                        summon.method_6997();
                    }
                }
            }
        }
    }

    private static void handleGivingOrSwappingItem(class_1309 livingActor, class_1309 livingTarget, class_1799 playerItemInSourceSlot, class_243 hitVec, class_1304 sourceSlot, class_1304 targetSlot) {
        class_1304 slotOnSummonToInteract = targetSlot != null ? targetSlot : TransferItemAction.getTargetSlotForPlayerItem(playerItemInSourceSlot, class_1304.field_6173);
        if (slotOnSummonToInteract == null) {
            return;
        }
        class_1799 summonItemInTargetSlot = livingTarget.method_6118(slotOnSummonToInteract).method_7972();
        livingTarget.method_5673(slotOnSummonToInteract, playerItemInSourceSlot);
        livingActor.method_5673(sourceSlot, summonItemInTargetSlot);
        if (livingTarget instanceof class_1308) {
            class_1308 mob = (class_1308)livingTarget;
            mob.method_5946(slotOnSummonToInteract, 1.0f);
            mob.method_5971();
            if (mob instanceof ISummon) {
                ISummon summon = (ISummon)mob;
                if (slotOnSummonToInteract == class_1304.field_6173) {
                    summon.method_6997();
                }
            }
        }
    }

    private static class_1304 getTargetSlotForPlayerItem(class_1799 stack, class_1304 defaultSlot) {
        if (stack.method_7960()) {
            return defaultSlot;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1819) {
            return class_1304.field_6171;
        }
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return armorItem.method_7685();
        }
        if (item instanceof class_1811 || item instanceof class_1829 || item instanceof class_1766 || item instanceof class_1835) {
            return class_1304.field_6173;
        }
        return defaultSlot;
    }

    private static class_1304 getClickedSlotOnSummon(class_1309 summon, class_243 worldHitPos, boolean forTakingItem) {
        double localOriginY = summon.method_23318();
        double hitY = worldHitPos.method_10214();
        double entityHeight = summon.method_17682();
        if (entityHeight <= 1.0E-5) {
            class_1304 fallbackSlot = class_1304.field_6173;
            if (forTakingItem && summon.method_6118(fallbackSlot).method_7960()) {
                return null;
            }
            return fallbackSlot;
        }
        double clampedHitY = Math.max(localOriginY, Math.min(hitY, localOriginY + entityHeight));
        double normalizedHitY = (clampedHitY - localOriginY) / entityHeight;
        class_1304 determinedArmorSlot = null;
        if (normalizedHitY >= 0.0 && normalizedHitY < 0.15) {
            determinedArmorSlot = class_1304.field_6166;
        } else if (normalizedHitY >= 0.15 && normalizedHitY < 0.5) {
            determinedArmorSlot = class_1304.field_6172;
        } else if (normalizedHitY >= 0.5 && normalizedHitY < 0.85) {
            determinedArmorSlot = class_1304.field_6174;
        } else if (normalizedHitY >= 0.85 && normalizedHitY <= 1.0) {
            determinedArmorSlot = class_1304.field_6169;
        } else if (normalizedHitY > 1.0 && normalizedHitY <= 1.15 && summon.method_6118(class_1304.field_6169).method_7909() instanceof class_1738) {
            determinedArmorSlot = class_1304.field_6169;
        }
        if (determinedArmorSlot != null) {
            if (forTakingItem) {
                class_1799 itemInDeterminedSlot = summon.method_6118(determinedArmorSlot);
                if (!itemInDeterminedSlot.method_7960()) {
                    return determinedArmorSlot;
                }
                if (determinedArmorSlot == class_1304.field_6169) {
                    if (!summon.method_6118(class_1304.field_6174).method_7960()) {
                        return class_1304.field_6174;
                    }
                } else if (determinedArmorSlot == class_1304.field_6174) {
                    if (!summon.method_6118(class_1304.field_6169).method_7960()) {
                        return class_1304.field_6169;
                    }
                    if (!summon.method_6118(class_1304.field_6172).method_7960()) {
                        return class_1304.field_6172;
                    }
                } else if (determinedArmorSlot == class_1304.field_6172) {
                    if (!summon.method_6118(class_1304.field_6166).method_7960()) {
                        return class_1304.field_6166;
                    }
                    if (!summon.method_6118(class_1304.field_6174).method_7960()) {
                        return class_1304.field_6174;
                    }
                } else if (determinedArmorSlot == class_1304.field_6166 && !summon.method_6118(class_1304.field_6172).method_7960()) {
                    return class_1304.field_6172;
                }
                return null;
            }
            return determinedArmorSlot;
        }
        class_1304 fallbackSlot = class_1304.field_6173;
        if (forTakingItem) {
            return summon.method_6118(fallbackSlot).method_7960() ? null : fallbackSlot;
        }
        return fallbackSlot;
    }
}

