/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3532;

public class ModifyDurabilityChangePower
extends ValueModifyingPower {
    private final Predicate<class_1799> itemCondition;
    private final Comparison comparison;
    private final int compareTo;
    private final Function function;

    public ModifyDurabilityChangePower(PowerType<?> type, class_1309 entity, Predicate<class_1799> itemCondition, Comparison comparison, int compareTo, Function function) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.comparison = comparison;
        this.compareTo = compareTo;
        this.function = function;
    }

    public boolean doesApply(class_1937 level, class_1799 stack, int durabilityChange) {
        return (this.itemCondition == null || this.itemCondition.test(stack)) && this.comparison.compare((double)durabilityChange, (double)this.compareTo);
    }

    public int postFunction(double value) {
        int retVal;
        switch (this.function) {
            case CEILING: {
                int n = class_3532.method_15382((int)class_3532.method_15384((double)value));
                break;
            }
            case ROUND: {
                int n = (int)class_3532.method_15379((float)Math.round(value));
                break;
            }
            default: {
                int n = retVal = class_3532.method_15382((int)class_3532.method_15357((double)value));
            }
        }
        if (value < 0.0) {
            retVal = -retVal;
        }
        return retVal;
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(MedievalOrigins.loc("modify_durability_change"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)Integer.MIN_VALUE).add("function", SerializableDataType.enumValue(Function.class), (Object)Function.FLOOR).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), data -> (type, player) -> {
            ModifyDurabilityChangePower power = new ModifyDurabilityChangePower((PowerType<?>)type, (class_1309)player, (Predicate)data.get("item_condition"), (Comparison)data.get("comparison"), data.getInt("compare_to"), (Function)((Object)((Object)((Object)data.get("function")))));
            Objects.requireNonNull(power);
            data.ifPresent("modifier", arg_0 -> ((ModifyDurabilityChangePower)power).addModifier(arg_0));
            data.ifPresent("modifiers", mods -> {
                Objects.requireNonNull(power);
                mods.forEach(arg_0 -> ((ModifyDurabilityChangePower)power).addModifier(arg_0));
            });
            return power;
        }).allowCondition();
    }

    public static enum Function {
        FLOOR,
        ROUND,
        CEILING;

    }
}

