/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.SummonedMob;
import dev.muon.medievalorigins.power.ModPowerTypes;
import io.github.apace100.apoli.condition.EntityCondition;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerConfiguration;
import io.github.apace100.apoli.power.type.AttributeModifying;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class OwnerAttributeTransferPowerType
extends PowerType
implements AttributeModifying {
    private final class_1320 attribute;
    private final class_6880<class_1320> cachedHolder;
    private final List<AttributedEntityAttributeModifier> baseModifiers;
    private List<AttributedEntityAttributeModifier> scaledModifiers;
    private final boolean updateHealth;
    private final int tickRate;
    private Integer startTicks = null;
    private Integer endTicks = null;
    private boolean wasActive = false;
    private double lastOwnerValue = 0.0;
    public static final PowerConfiguration<OwnerAttributeTransferPowerType> FACTORY = PowerConfiguration.conditionedOf((class_2960)MedievalOrigins.loc("owner_attribute_transfer"), (SerializableData)new SerializableData().add("owner_attribute", SerializableDataTypes.ATTRIBUTE).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true).add("tick_rate", SerializableDataTypes.POSITIVE_INT, (Object)20), (data, condition) -> new OwnerAttributeTransferPowerType((class_1320)data.get("owner_attribute"), (List)data.get("modifiers"), (Boolean)data.get("update_health"), (Integer)data.get("tick_rate"), (Optional<EntityCondition>)condition), (type, data) -> data.instance().set("owner_attribute", (Object)type.attribute).set("modifiers", type.baseModifiers).set("update_health", (Object)type.updateHealth).set("tick_rate", (Object)type.tickRate));

    public OwnerAttributeTransferPowerType(class_1320 ownerAttribute, List<AttributedEntityAttributeModifier> attributedModifiers, boolean updateHealth, int tickRate, Optional<EntityCondition> condition) {
        super(condition);
        this.attribute = ownerAttribute;
        this.cachedHolder = class_7923.field_41190.method_47983((Object)ownerAttribute);
        this.baseModifiers = attributedModifiers;
        this.scaledModifiers = new ArrayList<AttributedEntityAttributeModifier>(attributedModifiers);
        this.updateHealth = updateHealth;
        this.tickRate = tickRate;
    }

    @NotNull
    public PowerConfiguration<?> getConfig() {
        return ModPowerTypes.OWNER_ATTRIBUTE_TRANSFER;
    }

    public boolean shouldUpdateHealth() {
        return this.updateHealth;
    }

    private void updateScaledModifiersIfNeeded(double newOwnerValue) {
        if (this.lastOwnerValue != newOwnerValue) {
            this.scaledModifiers = this.baseModifiers.stream().map(mod -> new AttributedEntityAttributeModifier(mod.attribute(), new class_1322(mod.modifier().comp_2447(), mod.modifier().comp_2449() * newOwnerValue, mod.modifier().comp_2450()))).toList();
            this.lastOwnerValue = newOwnerValue;
        }
    }

    public void serverTick() {
        class_1309 class_13092 = this.getHolder();
        if (!(class_13092 instanceof SummonedMob)) {
            return;
        }
        SummonedMob summon = (SummonedMob)class_13092;
        class_1309 owner = summon.method_35057();
        if (owner == null) {
            return;
        }
        if (this.isActive()) {
            class_1324 ownerAttr;
            if (this.startTicks == null) {
                this.startTicks = this.getHolder().field_6012 % this.tickRate;
                this.endTicks = null;
            } else if (!this.wasActive && this.getHolder().field_6012 % this.tickRate == this.startTicks && (ownerAttr = owner.method_5996(this.cachedHolder)) != null) {
                this.updateScaledModifiersIfNeeded(ownerAttr.method_6194());
                this.addTemporaryModifiers(this.getHolder());
                this.wasActive = true;
            }
        } else if (this.wasActive) {
            if (this.endTicks == null) {
                this.startTicks = null;
                this.endTicks = this.getHolder().field_6012 % this.tickRate;
            } else if (this.getHolder().field_6012 % this.tickRate == this.endTicks) {
                this.removeModifiers(this.getHolder());
                this.wasActive = false;
            }
        }
    }

    public List<AttributedEntityAttributeModifier> attributedModifiers() {
        return this.scaledModifiers;
    }

    public void onAdded() {
        class_1324 ownerAttr;
        SummonedMob summon;
        class_1309 class_13092 = this.getHolder();
        if (class_13092 instanceof SummonedMob && (summon = (SummonedMob)class_13092).method_35057() != null && (ownerAttr = summon.method_35057().method_5996(this.cachedHolder)) != null) {
            this.updateScaledModifiersIfNeeded(ownerAttr.method_6194());
            this.addTemporaryModifiers(this.getHolder());
            this.wasActive = true;
        }
    }

    public void onRemoved() {
        this.removeModifiers(this.getHolder());
    }

    public void onLost() {
        this.removeModifiers(this.getHolder());
    }
}

