/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class AreaBonemealAction {
    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("area_bonemeal"), new SerializableData().add("radius", SerializableDataTypes.INT, (Object)5).add("vertical_radius", SerializableDataTypes.INT, (Object)2).add("particle_effect", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE, null), AreaBonemealAction::action);
    }

    public static void action(SerializableData.Instance data, Entity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int radius = data.getInt("radius");
        int verticalRadius = data.getInt("vertical_radius");
        ParticleOptions customParticleOptions = (ParticleOptions)data.get("particle_effect");
        BlockPos center = entity.m_20183_();
        int bonemealedCount = 0;
        int maxToBonemeal = 30;
        for (int y = -verticalRadius; y <= verticalRadius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius && bonemealedCount < maxToBonemeal; ++z) {
                    BonemealableBlock bonemealable;
                    BlockPos currentPos;
                    BlockState blockState;
                    Block block;
                    if (x * x + z * z > radius * radius || !((block = (blockState = level.m_8055_(currentPos = center.m_7918_(x, y, z))).m_60734_()) instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)level, currentPos, blockState, false) || !bonemealable.m_214167_(level, serverLevel.f_46441_, currentPos, blockState)) continue;
                    bonemealable.m_214148_(serverLevel, serverLevel.f_46441_, currentPos, blockState);
                    if (customParticleOptions != null) {
                        serverLevel.m_8767_(customParticleOptions, (double)currentPos.m_123341_() + 0.5, (double)currentPos.m_123342_() + 0.5, (double)currentPos.m_123343_() + 0.5, 5, 0.3, 0.3, 0.3, 0.0);
                    } else {
                        serverLevel.m_46796_(1505, currentPos, 0);
                    }
                    ++bonemealedCount;
                }
                if (bonemealedCount >= maxToBonemeal) break;
            }
            if (bonemealedCount >= maxToBonemeal) break;
        }
    }
}

