/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.condition.item;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.platform.Services;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantments;

public class IsValkyrieWeaponCondition {
    private static final Set<String> BASE_VALKYRIE_KEYWORDS = new HashSet<String>(Arrays.asList("glaive", "spear", "lance", "trident", "halberd"));
    private static final Set<String> EPIC_KNIGHTS_KEYWORDS = new HashSet<String>(Arrays.asList("pike", "ranseur", "ahlspiess", "guisarme", "poleaxe", "billhook", "fauchard", "partisan", "voulge", "rogatina", "doru", "retiarius", "sarissa"));

    public static boolean condition(SerializableData.Instance data, ItemStack stack) {
        boolean isWeapon;
        Item item = stack.m_41720_();
        String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_().toLowerCase(Locale.ROOT);
        boolean bl = isWeapon = item instanceof SwordItem || item instanceof TridentItem || Enchantments.f_44977_.m_6081_(stack) || Enchantments.f_44961_.m_6081_(stack);
        if (isWeapon) {
            for (String keyword : BASE_VALKYRIE_KEYWORDS) {
                if (!itemName.contains(keyword)) continue;
                return true;
            }
        }
        if (Services.PLATFORM.isModLoaded("magistuarmory")) {
            for (String keyword : EPIC_KNIGHTS_KEYWORDS) {
                if (!itemName.contains(keyword)) continue;
                return true;
            }
        }
        return false;
    }

    public static ConditionFactory<ItemStack> getFactory() {
        return new ConditionFactory(MedievalOrigins.loc("is_valkyrie_weapon"), new SerializableData(), IsValkyrieWeaponCondition::condition);
    }
}

