/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.muon.medievalorigins.power.EdibleItemPower;
import dev.muon.medievalorigins.power.ModifyDurabilityChangePower;
import io.github.apace100.apoli.access.EntityLinkedItemStack;
import io.github.apace100.apoli.component.PowerHolderComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemStack.class}, priority=1500)
public class ItemStackMixin {
    @ModifyReturnValue(method={"isEdible"}, at={@At(value="RETURN")})
    private boolean modifyIsEdible(boolean original) {
        ItemStack self = (ItemStack)this;
        if (self == null) {
            return original;
        }
        EntityLinkedItemStack heldStack = (EntityLinkedItemStack)self;
        return original || PowerHolderComponent.hasPower((Entity)heldStack.getEntity(), EdibleItemPower.class, power -> power.doesApply(heldStack.getEntity().m_9236_(), self));
    }

    @ModifyVariable(method={"setDamageValue"}, at=@At(value="HEAD"), argsOnly=true)
    private int medievalorigins$modifyDurabilityChange(int damage) {
        ItemStack self = (ItemStack)this;
        if (self == null) {
            return damage;
        }
        EntityLinkedItemStack heldStack = (EntityLinkedItemStack)self;
        Entity entity = heldStack.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CompoundTag tag = self.m_41784_();
            int previousDamage = tag.m_128425_("Damage", 3) ? tag.m_128451_("Damage") : 0;
            int originalDurabilityChange = damage - previousDamage;
            float modifiedValue = PowerHolderComponent.modify((Entity)living, ModifyDurabilityChangePower.class, (float)originalDurabilityChange, p -> p.doesApply(living.m_9236_(), self, originalDurabilityChange));
            int finalDurabilityChange = originalDurabilityChange;
            for (ModifyDurabilityChangePower power : PowerHolderComponent.getPowers((Entity)living, ModifyDurabilityChangePower.class)) {
                if (!power.doesApply(living.m_9236_(), self, originalDurabilityChange)) continue;
                finalDurabilityChange = power.postFunction(modifiedValue);
                break;
            }
            return previousDamage + finalDurabilityChange;
        }
        return damage;
    }
}

