/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ActionOnTargetDeathPower
extends CooldownPower {
    private final Consumer<Tuple<Entity, Entity>> biEntityAction;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;
    private final Predicate<Tuple<DamageSource, Float>> damageCondition;

    public ActionOnTargetDeathPower(PowerType<?> type, LivingEntity entity, Consumer<Tuple<Entity, Entity>> biEntityAction, Predicate<Tuple<Entity, Entity>> biEntityCondition, Predicate<Tuple<DamageSource, Float>> damageCondition, int cooldownDuration, HudRender hudRender) {
        super(type, entity, cooldownDuration, hudRender);
        this.biEntityAction = biEntityAction;
        this.biEntityCondition = biEntityCondition;
        this.damageCondition = damageCondition;
    }

    public boolean doesApply(Entity target, DamageSource source, float amount) {
        return !(!this.canUse() || this.damageCondition != null && !this.damageCondition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(amount))) || this.biEntityCondition != null && !this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)target)));
    }

    public void executeActions(Entity target, DamageSource source, float amount) {
        if (this.doesApply(target, source, amount)) {
            this.use();
            if (this.biEntityAction != null) {
                this.biEntityAction.accept((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)target));
            }
        }
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(MedievalOrigins.loc("action_on_target_death"), new SerializableData().add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER), data -> (type, entity) -> new ActionOnTargetDeathPower((PowerType<?>)type, (LivingEntity)entity, (Consumer)data.get("bientity_action"), (Predicate)data.get("bientity_condition"), (Predicate)data.get("damage_condition"), (Integer)data.get("cooldown"), (HudRender)data.get("hud_render"))).allowCondition();
    }
}

