/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributedDamageAction {
    static SerializableData modifierData = new SerializableData().add("attribute", SerializableDataTypes.IDENTIFIER, null).add("operation", SerializableDataTypes.MODIFIER_OPERATION).add("value", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f));

    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("damage"), new SerializableData().add("base", SerializableDataTypes.FLOAT).add("modifier", SerializableDataType.compound(SerializableData.Instance.class, (SerializableData)modifierData, Function.identity(), (data, instance) -> instance), null).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null), AttributedDamageAction::action);
    }

    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        Entity actor = (Entity)entities.m_14418_();
        Entity target = (Entity)entities.m_14419_();
        if (!(actor instanceof LivingEntity) || target == null) {
            return;
        }
        float baseDamage = ((Float)data.get("base")).floatValue();
        SerializableData.Instance modifier = (SerializableData.Instance)data.get("modifier");
        if (modifier != null) {
            ResourceLocation attributeLocation = (ResourceLocation)modifier.get("attribute");
            ResourceKey attributeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256728_, (ResourceLocation)attributeLocation);
            Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_6246_(attributeKey);
            AttributeModifier.Operation operation = (AttributeModifier.Operation)modifier.get("operation");
            float modifierValue = ((Float)modifier.get("value")).floatValue();
            if (attribute != null) {
                LivingEntity livingActor = (LivingEntity)actor;
                double attributeValue = livingActor.m_21133_(attribute);
                switch (operation) {
                    case ADDITION: {
                        baseDamage = (float)((double)baseDamage + attributeValue * (double)modifierValue);
                        break;
                    }
                    case MULTIPLY_BASE: {
                        baseDamage = (float)((double)baseDamage + (double)baseDamage * attributeValue * (double)modifierValue);
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        baseDamage = (float)((double)baseDamage + (double)baseDamage * attributeValue * (double)modifierValue);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown operation: " + String.valueOf(operation));
                    }
                }
            }
        }
        DamageSource source = MiscUtil.createDamageSource((DamageSources)actor.m_269291_(), (DamageSourceDescription)((DamageSourceDescription)data.get("source")), (ResourceKey)((ResourceKey)data.get("damage_type")), (Entity)actor);
        target.m_6469_(source, baseDamage);
    }
}

