/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.platform.Services;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SpellDamageAction {
    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("spell_damage"), new SerializableData().add("magic_school", SerializableDataTypes.STRING).add("crit_behavior", SerializableDataTypes.STRING, (Object)"normal").add("base", SerializableDataTypes.FLOAT).add("scaling_factor", SerializableDataTypes.FLOAT).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE), SpellDamageAction::action);
    }

    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        Entity actor = (Entity)entities.m_14418_();
        Entity target = (Entity)entities.m_14419_();
        if (!(actor instanceof LivingEntity) || target == null) {
            return;
        }
        float baseDamage = ((Float)data.get("base")).floatValue();
        float scalingFactor = ((Float)data.get("scaling_factor")).floatValue();
        String magicSchool = (String)data.get("magic_school");
        String critBehavior = (String)data.get("crit_behavior");
        double spellPower = Services.SPELL_POWER.getSpellPower(magicSchool, (LivingEntity)actor, critBehavior);
        double totalDamage = (double)baseDamage + spellPower * (double)scalingFactor;
        DamageSource source = MiscUtil.createDamageSource((DamageSources)actor.m_269291_(), (DamageSourceDescription)((DamageSourceDescription)data.get("source")), (ResourceKey)((ResourceKey)data.get("damage_type")), (Entity)actor);
        target.m_6469_(source, (float)totalDamage);
    }
}

