/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import dev.muon.medievalorigins.entity.SummonTracker;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SummonEntityAction {
    private static final int MAX_SUMMONS = 5;

    public static void action(SerializableData.Instance data, Entity caster) {
        if (!caster.m_9236_().m_5776_() && caster instanceof LivingEntity) {
            LivingEntity livingCaster = (LivingEntity)caster;
            ServerLevel serverWorld = (ServerLevel)caster.m_9236_();
            Integer duration = (Integer)data.get("duration");
            EntityType entityType = (EntityType)data.get("entity_type");
            CompoundTag entityNbt = (CompoundTag)data.get("tag");
            ItemStack weapon = (ItemStack)data.get("weapon");
            Optional entityToSpawnOpt = MiscUtil.getEntityWithPassengers((Level)serverWorld, (EntityType)entityType, (CompoundTag)entityNbt, (Vec3)caster.m_20182_(), (float)caster.m_146908_(), (float)caster.m_146909_());
            if (entityToSpawnOpt.isEmpty()) {
                return;
            }
            Entity entityToSpawn = (Entity)entityToSpawnOpt.get();
            if (entityToSpawn instanceof Mob) {
                Mob mob = (Mob)entityToSpawn;
                DifficultyInstance difficulty = serverWorld.m_6436_(mob.m_20183_());
                mob.m_6518_((ServerLevelAccessor)serverWorld, difficulty, MobSpawnType.MOB_SUMMONED, null, entityNbt);
                mob.m_21530_();
            }
            if (entityToSpawn instanceof ISummon) {
                ISummon summon = (ISummon)entityToSpawn;
                if (duration != null) {
                    summon.setLifeTicks(duration);
                    summon.setIsLimitedLife(true);
                } else {
                    summon.setIsLimitedLife(false);
                }
                summon.setOwner(livingCaster);
                summon.setOwnerID(caster.m_20148_());
                if (weapon != null && !weapon.m_41619_()) {
                    summon.setWeapon(weapon);
                }
            }
            serverWorld.m_8860_(entityToSpawn);
            SummonEntityAction.manageSummonLimit(caster);
            data.ifPresent("entity_action", entityAction -> entityAction.accept(entityToSpawn));
            data.ifPresent("bientity_action", biEntityAction -> biEntityAction.accept(new Tuple((Object)caster, (Object)entityToSpawn)));
        }
    }

    private static void manageSummonLimit(Entity owner) {
        Collection<ISummon> existingSummons = SummonTracker.getSummonsForOwner(owner.m_20148_());
        if (existingSummons.size() >= 5) {
            List summonsList = existingSummons.stream().sorted(SummonEntityAction.createSummonComparator()).collect(Collectors.toList());
            ISummon toRemove = (ISummon)summonsList.get(0);
            Mob mobToRemove = toRemove.getSelfAsMob();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                int x = (int)Math.round(mobToRemove.m_20185_());
                int y = (int)Math.round(mobToRemove.m_20186_());
                int z = (int)Math.round(mobToRemove.m_20189_());
                String dimension = mobToRemove.m_9236_().m_46472_().m_135782_().m_135815_();
                MutableComponent message = Component.m_237115_((String)"message.medievalorigins.summon_limit_reached").m_130946_(" ").m_7220_(mobToRemove.m_5446_()).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"message.medievalorigins.summon_location", (Object[])new Object[]{dimension, x, y, z}));
                player.m_5661_((Component)message, true);
            }
            mobToRemove.m_142687_(Entity.RemovalReason.DISCARDED);
            SummonTracker.untrackSummon(toRemove);
        }
    }

    private static Comparator<ISummon> createSummonComparator() {
        return (a, b) -> {
            boolean bLimited;
            LivingEntity entityA = a.getLivingEntity();
            LivingEntity entityB = b.getLivingEntity();
            if (entityA == null || entityB == null) {
                return entityA == null ? -1 : 1;
            }
            boolean aLimited = a.isLimitedLife();
            if (aLimited != (bLimited = b.isLimitedLife())) {
                return aLimited ? -1 : 1;
            }
            if (aLimited && bLimited) {
                return Integer.compare(a.getTicksLeft(), b.getTicksLeft());
            }
            return SummonEntityAction.compareMobTypes(SummonEntityAction.toMob(entityA), SummonEntityAction.toMob(entityB));
        };
    }

    private static Mob toMob(LivingEntity entity) {
        return entity instanceof Mob ? (Mob)entity : null;
    }

    private static int compareMobTypes(Mob a, Mob b) {
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int priorityA = SummonEntityAction.getMobPriority(a);
        int priorityB = SummonEntityAction.getMobPriority(b);
        return Integer.compare(priorityA, priorityB);
    }

    private static int getMobPriority(Mob mob) {
        String entityId;
        return switch (entityId = mob.m_6095_().toString()) {
            case "entity.medievalorigins.summon_wither_skeleton" -> 3;
            case "entity.medievalorigins.summon_skeleton" -> 2;
            case "entity.medievalorigins.summon_zombie" -> 1;
            default -> 0;
        };
    }

    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("summon_entity"), new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("weapon", SerializableDataTypes.ITEM_STACK, null).add("duration", SerializableDataTypes.INT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null), SummonEntityAction::action);
    }
}

