/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.muon.medievalorigins.attribute.ModAttributes;
import dev.muon.medievalorigins.power.ActionOnJumpPower;
import dev.muon.medievalorigins.power.ActionOnTargetDeathPower;
import dev.muon.medievalorigins.power.CustomDeathSoundPower;
import dev.muon.medievalorigins.power.EdibleItemPower;
import dev.muon.medievalorigins.power.MobsIgnorePower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private static final TagKey<DamageType> MAGIC_DAMAGE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("medievalorigins", "is_magic"));

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true, index=2)
    private float modifyDamageAmount(float damageAmount, DamageSource damageSource) {
        if (damageAmount <= 0.0f) {
            return damageAmount;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (damageSource.m_7640_() instanceof Projectile || damageSource.m_269533_(DamageTypeTags.f_268524_)) {
                damageAmount += (float)attacker.m_21133_(ModAttributes.SUMMON_RANGED_DAMAGE);
            }
        }
        return damageAmount;
    }

    @ModifyExpressionValue(method={"shouldTriggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I")})
    private int modifyUseDuration(int original) {
        LivingEntity self = (LivingEntity)this;
        ItemStack useItem = self.m_21120_(self.m_7655_());
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            if (!power.doesApply(self.m_9236_(), useItem)) continue;
            FoodProperties foodProperties = power.getFoodComponent();
            return foodProperties != null && foodProperties.m_38748_() ? 16 : 32;
        }
        return original;
    }

    @ModifyExpressionValue(method={"shouldTriggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getFoodProperties(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/food/FoodProperties;")}, remap=false)
    private FoodProperties modifyGetFoodProperties(FoodProperties original) {
        LivingEntity self = (LivingEntity)this;
        ItemStack useItem = self.m_21120_(self.m_7655_());
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            if (!power.doesApply(self.m_9236_(), useItem)) continue;
            return power.getFoodComponent();
        }
        return original;
    }

    @WrapOperation(method={"shouldTriggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I")})
    private int medievalorigins$customUseDurationInShouldTrigger(ItemStack stack, Operation<Integer> original) {
        LivingEntity self = (LivingEntity)this;
        int originalDuration = (Integer)original.call(new Object[]{stack});
        if (originalDuration == 0) {
            for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
                FoodProperties foodProps;
                if (!power.doesApply(self.m_9236_(), stack) || (foodProps = power.getFoodComponent()) == null) continue;
                return foodProps.m_38748_() ? 16 : 32;
            }
        }
        return originalDuration;
    }

    @WrapOperation(method={"triggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseAnimation()Lnet/minecraft/world/item/UseAnim;")})
    private UseAnim medievalorigins$modifyUseAnimation(ItemStack stack, Operation<UseAnim> original) {
        LivingEntity self = (LivingEntity)this;
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            UseAnim customAnim;
            if (!power.doesApply(self.m_9236_(), stack) || (customAnim = power.getUseAction()) == null || customAnim == UseAnim.NONE) continue;
            return customAnim;
        }
        return (UseAnim)original.call(new Object[]{stack});
    }

    @WrapOperation(method={"triggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEatingSound(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/sounds/SoundEvent;")})
    private SoundEvent medievalorigins$customEatingTickSound(LivingEntity instance, ItemStack stack, Operation<SoundEvent> original) {
        LivingEntity self = (LivingEntity)this;
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            SoundEvent customSound;
            if (!power.doesApply(self.m_9236_(), stack) || (customSound = power.getSound()) == null) continue;
            return customSound;
        }
        return (SoundEvent)original.call(new Object[]{instance, stack});
    }

    @WrapOperation(method={"triggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDrinkingSound(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/sounds/SoundEvent;")})
    private SoundEvent medievalorigins$customDrinkingTickSound(LivingEntity instance, ItemStack stack, Operation<SoundEvent> original) {
        LivingEntity self = (LivingEntity)this;
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            SoundEvent customSound;
            if (!power.doesApply(self.m_9236_(), stack) || (customSound = power.getSound()) == null) continue;
            return customSound;
        }
        return (SoundEvent)original.call(new Object[]{instance, stack});
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="HEAD")})
    private void medievalorigins$completeUsingItem(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        ItemStack useItem = self.m_21120_(self.m_7655_());
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            Player player;
            ItemStack returnStack;
            if (!power.doesApply(self.m_9236_(), useItem)) continue;
            if (power.entityActionWhenEaten != null) {
                power.entityActionWhenEaten.accept((Entity)self);
            }
            if (power.itemActionWhenEaten != null) {
                power.itemActionWhenEaten.accept((Tuple<Level, ItemStack>)new Tuple((Object)self.m_9236_(), (Object)useItem));
            }
            if ((returnStack = power.getReturnStack()) == null || returnStack.m_41619_() || !(self instanceof Player) || (player = (Player)self).m_150109_().m_36054_(returnStack.m_41777_())) continue;
            player.m_36176_(returnStack.m_41777_(), false);
        }
    }

    @ModifyExpressionValue(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEdible()Z")})
    private boolean medievalorigins$isEdibleInEat(boolean original, @Local(argsOnly=true) ItemStack food) {
        LivingEntity self = (LivingEntity)this;
        if (!original) {
            for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
                if (!power.doesApply(self.m_9236_(), food)) continue;
                return true;
            }
        }
        return original;
    }

    @WrapOperation(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEatingSound(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/sounds/SoundEvent;")})
    private SoundEvent medievalorigins$customEatingSound(LivingEntity instance, ItemStack food, Operation<SoundEvent> original) {
        LivingEntity self = (LivingEntity)this;
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            SoundEvent customSound;
            if (!power.doesApply(self.m_9236_(), food) || (customSound = power.getSound()) == null) continue;
            return customSound;
        }
        return (SoundEvent)original.call(new Object[]{instance, food});
    }

    @ModifyExpressionValue(method={"addEatEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;isEdible()Z")})
    private boolean medievalorigins$isEdibleInAddEatEffect(boolean original, @Local(argsOnly=true) ItemStack food, @Local(argsOnly=true) LivingEntity livingEntity) {
        if (!original) {
            for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)livingEntity, EdibleItemPower.class)) {
                if (!power.doesApply(livingEntity.m_9236_(), food)) continue;
                return true;
            }
        }
        return original;
    }

    @WrapOperation(method={"addEatEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getFoodProperties(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/food/FoodProperties;", remap=false)})
    private FoodProperties medievalorigins$customFoodPropertiesInAddEatEffect(ItemStack instance, LivingEntity livingEntity, Operation<FoodProperties> original, @Local(argsOnly=true) ItemStack food) {
        FoodProperties originalFood = (FoodProperties)original.call(new Object[]{instance, livingEntity});
        if (originalFood != null) {
            return originalFood;
        }
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)livingEntity, EdibleItemPower.class)) {
            if (!power.doesApply(livingEntity.m_9236_(), food)) continue;
            return power.getFoodComponent();
        }
        return null;
    }

    @Inject(method={"startUsingItem"}, at={@At(value="TAIL")})
    private void medievalorigins$syncEdiblePowerOnStart(InteractionHand hand, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = self.m_21120_(hand);
        for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
            if (!power.doesApply(self.m_9236_(), stack)) continue;
            PowerHolderComponent.syncPower((Entity)self, (PowerType)power.getType());
            return;
        }
    }

    @WrapOperation(method={"startUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I")})
    private int medievalorigins$customUseDurationInStart(ItemStack stack, Operation<Integer> original) {
        LivingEntity self = (LivingEntity)this;
        int originalDuration = (Integer)original.call(new Object[]{stack});
        if (originalDuration == 0) {
            for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
                FoodProperties foodProps;
                if (!power.doesApply(self.m_9236_(), stack) || (foodProps = power.getFoodComponent()) == null) continue;
                return foodProps.m_38748_() ? 16 : 32;
            }
        }
        return originalDuration;
    }

    @WrapOperation(method={"onSyncedDataUpdated"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I")})
    private int medievalorigins$customUseDurationInSync(ItemStack stack, Operation<Integer> original) {
        LivingEntity self = (LivingEntity)this;
        int originalDuration = (Integer)original.call(new Object[]{stack});
        if (originalDuration == 0) {
            for (EdibleItemPower power : PowerHolderComponent.getPowers((Entity)self, EdibleItemPower.class)) {
                FoodProperties foodProps;
                if (!power.doesApply(self.m_9236_(), stack) || (foodProps = power.getFoodComponent()) == null) continue;
                return foodProps.m_38748_() ? 16 : 32;
            }
        }
        return originalDuration;
    }

    @Unique
    private boolean medievalorigins$shouldIgnoreTarget(Player player) {
        LivingEntity self = (LivingEntity)this;
        return PowerHolderComponent.getPowers((Entity)player, MobsIgnorePower.class).stream().filter(Power::isActive).anyMatch(power -> power.shouldIgnore((Entity)self, (Entity)player));
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void medievalorigins$preventAttackValidation(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        if (target instanceof Player && this.medievalorigins$shouldIgnoreTarget(player = (Player)target)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;die(Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void medievalorigins$invokeTargetDeathAction(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity self = (LivingEntity)this;
            PowerHolderComponent.getPowers((Entity)attacker, ActionOnTargetDeathPower.class).stream().filter(power -> power.doesApply((Entity)self, source, amount)).forEach(power -> power.executeActions((Entity)self, source, amount));
        }
    }

    @WrapOperation(method={"handleEntityEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V", ordinal=0)})
    private void medievalorigins$onDeathSound(LivingEntity instance, SoundEvent soundEvent, float volume, float pitch, Operation<Void> original) {
        LivingEntity self = (LivingEntity)this;
        List powers = PowerHolderComponent.getPowers((Entity)self, CustomDeathSoundPower.class);
        if (!powers.isEmpty()) {
            boolean anyMuted = powers.stream().anyMatch(CustomDeathSoundPower::isMuted);
            if (!anyMuted) {
                powers.forEach(power -> power.playDeathSound((Entity)self));
            }
        } else {
            original.call(new Object[]{instance, soundEvent, Float.valueOf(volume), Float.valueOf(pitch)});
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    private void medievalorigins$onJump(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        PowerHolderComponent.getPowers((Entity)self, ActionOnJumpPower.class).forEach(power -> power.executeAction((Entity)self));
    }
}

