/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MobsIgnorePower
extends Power {
    private final Predicate<Entity> mobCondition;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;

    public MobsIgnorePower(PowerType<?> type, LivingEntity entity, Predicate<Entity> mobCondition, Predicate<Tuple<Entity, Entity>> biEntityCondition) {
        super(type, entity);
        this.mobCondition = mobCondition;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean shouldIgnore(Entity mob, Entity holder) {
        boolean mobTest = this.mobCondition == null || this.mobCondition.test(mob);
        boolean biEntityTest = this.biEntityCondition == null || this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)holder, (Object)mob));
        return mobTest && biEntityTest;
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(MedievalOrigins.loc("mobs_ignore"), new SerializableData().add("mob_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), data -> (type, entity) -> new MobsIgnorePower((PowerType<?>)type, (LivingEntity)entity, (Predicate)data.get("mob_condition"), (Predicate)data.get("bientity_condition"))).allowCondition();
    }
}

