/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class OwnerAttributeTransferPower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;
    private final boolean updateHealth;
    private Attribute ownerAttribute;

    public OwnerAttributeTransferPower(PowerType<?> type, LivingEntity entity, int tickRate, boolean updateHealth) {
        super(type, entity);
        this.setTicking(true);
        this.tickRate = tickRate;
        this.updateHealth = updateHealth;
    }

    public void setOwnerAttribute(Attribute ownerAttribute) {
        this.ownerAttribute = ownerAttribute;
    }

    public OwnerAttributeTransferPower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void tick() {
        if (this.entity.f_19797_ % this.tickRate == 0) {
            if (this.isActive()) {
                this.applyModifiers();
            } else {
                this.removeModifiers();
            }
        }
    }

    public void onRemoved() {
        this.removeModifiers();
    }

    private void applyModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.m_21233_();
            double previousHealthPercent = (double)this.entity.m_21223_() / previousMaxHealth;
            LivingEntity owner = ((ISummon)this.entity).m_269323_();
            if (owner != null && this.ownerAttribute != null) {
                AttributeInstance ownerAttributeInstance = owner.m_21051_(this.ownerAttribute);
                if (ownerAttributeInstance != null) {
                    double ownerAttributeValue = ownerAttributeInstance.m_22135_();
                    this.modifiers.forEach(mod -> {
                        AttributeInstance summonAttributeInstance = this.entity.m_21051_(mod.getAttribute());
                        if (summonAttributeInstance != null) {
                            double finalModifierAmount = ownerAttributeValue * mod.getModifier().m_22218_();
                            AttributeModifier newModifier = new AttributeModifier(mod.getModifier().m_22209_(), mod.getModifier().m_22214_(), finalModifierAmount, mod.getModifier().m_22217_());
                            if (!summonAttributeInstance.m_22109_(newModifier)) {
                                summonAttributeInstance.m_22118_(newModifier);
                            }
                        }
                    });
                }
                if (this.updateHealth) {
                    double afterMaxHealth = this.entity.m_21233_();
                    this.entity.m_21153_((float)(afterMaxHealth * previousHealthPercent));
                }
            }
        }
    }

    private void removeModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.m_21233_();
            double previousHealthPercent = (double)this.entity.m_21223_() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                AttributeInstance summonAttributeInstance = this.entity.m_21051_(mod.getAttribute());
                if (summonAttributeInstance != null) {
                    summonAttributeInstance.m_22130_(mod.getModifier());
                }
            });
            if (this.updateHealth) {
                double afterMaxHealth = this.entity.m_21233_();
                this.entity.m_21153_((float)(afterMaxHealth * previousHealthPercent));
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(MedievalOrigins.loc("owner_attribute_transfer"), new SerializableData().add("owner_attribute", SerializableDataTypes.ATTRIBUTE).add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("tick_rate", SerializableDataTypes.INT, (Object)20).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, entity) -> {
            OwnerAttributeTransferPower power = new OwnerAttributeTransferPower((PowerType<?>)type, (LivingEntity)entity, data.getInt("tick_rate"), data.getBoolean("update_health"));
            power.setOwnerAttribute((Attribute)data.get("owner_attribute"));
            if (data.isPresent("modifier")) {
                power.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition();
    }
}

