/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import dev.muon.medievalorigins.entity.ModEntities;
import dev.muon.medievalorigins.entity.SummonTracker;
import dev.muon.medievalorigins.sounds.ModSounds;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;

public class MedievalOriginsFabric
implements ModInitializer {
    public void onInitialize() {
        MedievalOrigins.LOG.info("Loading Medieval Origins");
        MedievalOrigins.init();
        ModEntities.register();
        ModSounds.register();
        this.registerSummonTrackerEvents();
    }

    private void registerSummonTrackerEvents() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof ISummon) {
                ISummon summon = (ISummon)entity;
                SummonTracker.onEntityLoad(summon);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> SummonTracker.onServerTick());
        ServerWorldEvents.UNLOAD.register((server, world) -> SummonTracker.onWorldUnload());
        MedievalOrigins.LOG.info("Registered SummonTracker events (Fabric)");
    }
}

