/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.platform;

import dev.muon.medievalorigins.compat.SpellEngineUtils;
import dev.muon.medievalorigins.platform.services.ISpellHelper;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class FabricSpellPowerHelper
implements ISpellHelper {
    @Override
    public double getSpellPower(String magicSchool, class_1309 actor, String critBehavior) {
        if (!FabricLoader.getInstance().isModLoaded("spell_power")) {
            return 0.0;
        }
        try {
            SpellSchool school = SpellSchools.getSchool((String)magicSchool);
            if (school == null) {
                return 0.0;
            }
            SpellPower.Result spellPowerResult = SpellPower.getSpellPower((SpellSchool)school, (class_1309)actor);
            return switch (critBehavior) {
                case "always" -> spellPowerResult.forcedCriticalValue();
                case "never" -> spellPowerResult.nonCriticalValue();
                default -> spellPowerResult.randomValue();
            };
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public void castSpell(class_1297 entity, class_2960 spellId, boolean requireAmmo, String targetType, float range, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        if (!FabricLoader.getInstance().isModLoaded("spell_engine")) {
            return;
        }
        SpellEngineUtils.castSpell(entity, spellId, requireAmmo, targetType, range);
    }

    @Override
    public void castSpellWithTarget(class_1297 actor, class_1297 target, class_2960 spellId, boolean requireAmmo, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
        if (!FabricLoader.getInstance().isModLoaded("spell_engine")) {
            return;
        }
        SpellEngineUtils.castSpellOnTarget(actor, target, spellId, requireAmmo);
    }

    @Override
    public String getSpellSystem() {
        return FabricLoader.getInstance().isModLoaded("spell_engine") ? "spell_engine" : "none";
    }
}

