/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.entity;

import dev.muon.medievalorigins.entity.ISummon;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;

public class SummonTracker {
    private static final Map<UUID, Set<ISummon>> OWNER_TO_SUMMONS = new ConcurrentHashMap<UUID, Set<ISummon>>();
    private static int cleanupTicks = 0;
    private static final int CLEANUP_INTERVAL = 200;

    public static void onEntityLoad(ISummon summon) {
        SummonTracker.trackSummon(summon);
    }

    public static void onServerTick() {
        if (++cleanupTicks >= 200) {
            cleanupTicks = 0;
            SummonTracker.cleanupInvalidSummons();
        }
    }

    public static void onWorldUnload() {
        OWNER_TO_SUMMONS.clear();
    }

    public static void trackSummon(ISummon summon) {
        UUID ownerID = summon.m_21805_();
        if (ownerID != null) {
            OWNER_TO_SUMMONS.computeIfAbsent(ownerID, k -> ConcurrentHashMap.newKeySet()).add(summon);
        }
    }

    public static void untrackSummon(ISummon summon) {
        Set<ISummon> summons;
        UUID ownerID = summon.m_21805_();
        if (ownerID != null && (summons = OWNER_TO_SUMMONS.get(ownerID)) != null) {
            summons.remove(summon);
            if (summons.isEmpty()) {
                OWNER_TO_SUMMONS.remove(ownerID);
            }
        }
    }

    public static Collection<ISummon> getSummonsForOwner(UUID ownerID) {
        return OWNER_TO_SUMMONS.getOrDefault(ownerID, Collections.emptySet());
    }

    public static void cleanupInvalidSummons() {
        OWNER_TO_SUMMONS.values().forEach(summons -> summons.removeIf(summon -> {
            LivingEntity entity = summon.getLivingEntity();
            return entity == null || !entity.m_6084_() || summon.m_21805_() == null;
        }));
    }
}

