/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins;

import com.bawnorton.mixinsquared.api.MixinCanceller;
import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import dev.muon.medievalorigins.MedievalOriginsMixinCanceller;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MedievalOriginsForgeMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Medieval Origins");

    public void onLoad(String mixinPackage) {
        LOGGER.info("MedievalOriginsForgeMixinPlugin.onLoad called with package: {}", (Object)mixinPackage);
        MixinCancellerRegistrar.register((MixinCanceller)new MedievalOriginsMixinCanceller());
        LOGGER.info("MedievalOriginsForgeMixinPlugin initialized successfully");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        LOGGER.info("shouldApplyMixin called - target: {}, mixin: {}", (Object)targetClassName, (Object)mixinClassName);
        if (mixinClassName.contains(".compat.")) {
            String[] parts = mixinClassName.split("\\.");
            ArrayList<String> requiredMods = new ArrayList<String>();
            Set<String> excludedDirectories = Set.of("client", "accessor");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].equals("compat")) continue;
                for (int j = i + 1; j < parts.length - 1; ++j) {
                    String potentialModId = parts[j];
                    if (excludedDirectories.contains(potentialModId)) continue;
                    requiredMods.add(potentialModId);
                }
                break;
            }
            for (String modId : requiredMods) {
                if (MedievalOriginsForgeMixinPlugin.isModLoaded(modId)) continue;
                LOGGER.info("Disabling mixin {} because required mod '{}' is not loaded", (Object)this.getSimpleMixinName(mixinClassName), (Object)modId);
                return false;
            }
            if (!requiredMods.isEmpty()) {
                LOGGER.info("Enabling mixin {} - all required mods {} are loaded", (Object)this.getSimpleMixinName(mixinClassName), requiredMods);
            }
            return true;
        }
        LOGGER.info("Enabling mixin {} (not a compat mixin)", (Object)this.getSimpleMixinName(mixinClassName));
        return true;
    }

    private String getSimpleMixinName(String mixinClassName) {
        String[] parts = mixinClassName.split("\\.");
        return parts[parts.length - 1];
    }

    private static boolean isModLoaded(String modId) {
        return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modId::equals);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

