/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TransferItemAction {
    private static final double MAX_INTERACTION_DISTANCE = 6.0;

    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("transfer_item"), new SerializableData().add("source_slot", SerializableDataTypes.EQUIPMENT_SLOT, (Object)EquipmentSlot.MAINHAND).add("target_slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("prioritize_mainhand_for_take", SerializableDataTypes.BOOLEAN, (Object)false).add("allow_empty_hand_mainhand_take", SerializableDataTypes.BOOLEAN, (Object)false), TransferItemAction::action);
    }

    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        LivingEntity livingActor;
        Entity target;
        block7: {
            block6: {
                Entity actor = (Entity)entities.m_14418_();
                target = (Entity)entities.m_14419_();
                if (actor.m_9236_().m_5776_()) {
                    return;
                }
                if (!(actor instanceof LivingEntity)) break block6;
                livingActor = (LivingEntity)actor;
                if (target instanceof LivingEntity) break block7;
            }
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        EquipmentSlot sourceSlot = (EquipmentSlot)data.get("source_slot");
        EquipmentSlot targetSlot = (EquipmentSlot)data.get("target_slot");
        boolean prioritizeMainhandForTake = (Boolean)data.get("prioritize_mainhand_for_take");
        boolean allowEmptyHandMainhandTake = (Boolean)data.get("allow_empty_hand_mainhand_take");
        Vec3 eyePosition = livingActor.m_146892_();
        Vec3 lookVector = livingActor.m_20154_();
        AABB targetBoundingBox = livingTarget.m_20191_();
        Optional clipResult = targetBoundingBox.m_82371_(eyePosition, eyePosition.m_82549_(lookVector.m_82490_(6.0)));
        Vec3 hitVec = clipResult.orElse(null);
        ItemStack playerItemInSourceSlot = livingActor.m_6844_(sourceSlot).m_41777_();
        if (playerItemInSourceSlot.m_41619_()) {
            TransferItemAction.handleTakingItem(livingActor, livingTarget, hitVec, sourceSlot, prioritizeMainhandForTake, allowEmptyHandMainhandTake);
        } else {
            TransferItemAction.handleGivingOrSwappingItem(livingActor, livingTarget, playerItemInSourceSlot, hitVec, sourceSlot, targetSlot);
        }
    }

    private static void handleTakingItem(LivingEntity livingActor, LivingEntity livingTarget, Vec3 hitVec, EquipmentSlot sourceSlot, boolean prioritizeMainhandForTake, boolean allowEmptyHandMainhandTake) {
        EquipmentSlot slotOnSummonToInteract = null;
        if (prioritizeMainhandForTake) {
            if (!livingTarget.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                slotOnSummonToInteract = EquipmentSlot.MAINHAND;
            } else if (hitVec != null) {
                slotOnSummonToInteract = TransferItemAction.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
        } else {
            if (hitVec != null) {
                slotOnSummonToInteract = TransferItemAction.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
            if (slotOnSummonToInteract == null && !livingTarget.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                slotOnSummonToInteract = EquipmentSlot.MAINHAND;
            }
        }
        if (slotOnSummonToInteract != null) {
            if (slotOnSummonToInteract == EquipmentSlot.MAINHAND && !allowEmptyHandMainhandTake) {
                return;
            }
            ItemStack summonItemInClickedSlot = livingTarget.m_6844_(slotOnSummonToInteract).m_41777_();
            if (!summonItemInClickedSlot.m_41619_()) {
                livingActor.m_8061_(sourceSlot, summonItemInClickedSlot);
                livingTarget.m_8061_(slotOnSummonToInteract, ItemStack.f_41583_);
                if (livingTarget instanceof ISummon) {
                    ISummon summon = (ISummon)livingTarget;
                    if (slotOnSummonToInteract == EquipmentSlot.MAINHAND) {
                        summon.reassessWeaponGoal();
                    }
                }
            }
        }
    }

    private static void handleGivingOrSwappingItem(LivingEntity livingActor, LivingEntity livingTarget, ItemStack playerItemInSourceSlot, Vec3 hitVec, EquipmentSlot sourceSlot, EquipmentSlot targetSlot) {
        EquipmentSlot slotOnSummonToInteract = targetSlot != null ? targetSlot : TransferItemAction.getTargetSlotForPlayerItem(playerItemInSourceSlot, EquipmentSlot.MAINHAND);
        if (slotOnSummonToInteract == null) {
            return;
        }
        ItemStack summonItemInTargetSlot = livingTarget.m_6844_(slotOnSummonToInteract).m_41777_();
        livingTarget.m_8061_(slotOnSummonToInteract, playerItemInSourceSlot);
        livingActor.m_8061_(sourceSlot, summonItemInTargetSlot);
        if (livingTarget instanceof Mob) {
            Mob mob = (Mob)livingTarget;
            mob.m_21409_(slotOnSummonToInteract, 1.0f);
            mob.m_21530_();
            if (mob instanceof ISummon) {
                ISummon summon = (ISummon)mob;
                if (slotOnSummonToInteract == EquipmentSlot.MAINHAND) {
                    summon.reassessWeaponGoal();
                }
            }
        }
    }

    private static EquipmentSlot getTargetSlotForPlayerItem(ItemStack stack, EquipmentSlot defaultSlot) {
        if (stack.m_41619_()) {
            return defaultSlot;
        }
        Item item = stack.m_41720_();
        if (item instanceof ShieldItem) {
            return EquipmentSlot.OFFHAND;
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40402_();
        }
        if (item instanceof ProjectileWeaponItem || item instanceof SwordItem || item instanceof DiggerItem || item instanceof TridentItem) {
            return EquipmentSlot.MAINHAND;
        }
        return defaultSlot;
    }

    private static EquipmentSlot getClickedSlotOnSummon(LivingEntity summon, Vec3 worldHitPos, boolean forTakingItem) {
        double localOriginY = summon.m_20186_();
        double hitY = worldHitPos.m_7098_();
        double entityHeight = summon.m_20206_();
        if (entityHeight <= 1.0E-5) {
            EquipmentSlot fallbackSlot = EquipmentSlot.MAINHAND;
            if (forTakingItem && summon.m_6844_(fallbackSlot).m_41619_()) {
                return null;
            }
            return fallbackSlot;
        }
        double clampedHitY = Math.max(localOriginY, Math.min(hitY, localOriginY + entityHeight));
        double normalizedHitY = (clampedHitY - localOriginY) / entityHeight;
        EquipmentSlot determinedArmorSlot = null;
        if (normalizedHitY >= 0.0 && normalizedHitY < 0.15) {
            determinedArmorSlot = EquipmentSlot.FEET;
        } else if (normalizedHitY >= 0.15 && normalizedHitY < 0.5) {
            determinedArmorSlot = EquipmentSlot.LEGS;
        } else if (normalizedHitY >= 0.5 && normalizedHitY < 0.85) {
            determinedArmorSlot = EquipmentSlot.CHEST;
        } else if (normalizedHitY >= 0.85 && normalizedHitY <= 1.0) {
            determinedArmorSlot = EquipmentSlot.HEAD;
        } else if (normalizedHitY > 1.0 && normalizedHitY <= 1.15 && summon.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorItem) {
            determinedArmorSlot = EquipmentSlot.HEAD;
        }
        if (determinedArmorSlot != null) {
            if (forTakingItem) {
                ItemStack itemInDeterminedSlot = summon.m_6844_(determinedArmorSlot);
                if (!itemInDeterminedSlot.m_41619_()) {
                    return determinedArmorSlot;
                }
                if (determinedArmorSlot == EquipmentSlot.HEAD) {
                    if (!summon.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                        return EquipmentSlot.CHEST;
                    }
                } else if (determinedArmorSlot == EquipmentSlot.CHEST) {
                    if (!summon.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                        return EquipmentSlot.HEAD;
                    }
                    if (!summon.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                        return EquipmentSlot.LEGS;
                    }
                } else if (determinedArmorSlot == EquipmentSlot.LEGS) {
                    if (!summon.m_6844_(EquipmentSlot.FEET).m_41619_()) {
                        return EquipmentSlot.FEET;
                    }
                    if (!summon.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                        return EquipmentSlot.CHEST;
                    }
                } else if (determinedArmorSlot == EquipmentSlot.FEET && !summon.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                    return EquipmentSlot.LEGS;
                }
                return null;
            }
            return determinedArmorSlot;
        }
        EquipmentSlot fallbackSlot = EquipmentSlot.MAINHAND;
        if (forTakingItem) {
            return summon.m_6844_(fallbackSlot).m_41619_() ? null : fallbackSlot;
        }
        return fallbackSlot;
    }
}

