/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModifyDurabilityChangePower
extends ValueModifyingPower {
    private final Predicate<ItemStack> itemCondition;
    private final Comparison comparison;
    private final int compareTo;
    private final Function function;

    public ModifyDurabilityChangePower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> itemCondition, Comparison comparison, int compareTo, Function function) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.comparison = comparison;
        this.compareTo = compareTo;
        this.function = function;
    }

    public boolean doesApply(Level level, ItemStack stack, int durabilityChange) {
        return (this.itemCondition == null || this.itemCondition.test(stack)) && this.comparison.compare((double)durabilityChange, (double)this.compareTo);
    }

    public int postFunction(double value) {
        int retVal;
        switch (this.function) {
            case CEILING: {
                int n = Mth.m_14040_((int)Mth.m_14165_((double)value));
                break;
            }
            case ROUND: {
                int n = (int)Mth.m_14154_((float)Math.round(value));
                break;
            }
            default: {
                int n = retVal = Mth.m_14040_((int)Mth.m_14107_((double)value));
            }
        }
        if (value < 0.0) {
            retVal = -retVal;
        }
        return retVal;
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(MedievalOrigins.loc("modify_durability_change"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)Integer.MIN_VALUE).add("function", SerializableDataType.enumValue(Function.class), (Object)Function.FLOOR).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), data -> (type, player) -> {
            ModifyDurabilityChangePower power = new ModifyDurabilityChangePower((PowerType<?>)type, (LivingEntity)player, (Predicate)data.get("item_condition"), (Comparison)data.get("comparison"), data.getInt("compare_to"), (Function)((Object)((Object)((Object)data.get("function")))));
            Objects.requireNonNull(power);
            data.ifPresent("modifier", arg_0 -> ((ModifyDurabilityChangePower)power).addModifier(arg_0));
            data.ifPresent("modifiers", mods -> {
                Objects.requireNonNull(power);
                mods.forEach(arg_0 -> ((ModifyDurabilityChangePower)power).addModifier(arg_0));
            });
            return power;
        }).allowCondition();
    }

    public static enum Function {
        FLOOR,
        ROUND,
        CEILING;

    }
}

