/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.blasttravel.client.entity;

import foundationgames.blasttravel.BlastTravel;
import foundationgames.blasttravel.entity.CannonEntity;
import foundationgames.blasttravel.entity.cannon.CannonBehavior;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Vector3f;

public class CannonEntityRenderer
extends class_897<CannonEntity> {
    public static final class_5601 MODEL = new class_5601(BlastTravel.id("cannon"), "main");
    private static final class_2960[] FIRE_TEXTURES = new class_2960[]{BlastTravel.id("textures/entity/cannon_fire/frame_0.png"), BlastTravel.id("textures/entity/cannon_fire/frame_1.png"), BlastTravel.id("textures/entity/cannon_fire/frame_2.png"), BlastTravel.id("textures/entity/cannon_fire/frame_3.png"), BlastTravel.id("textures/entity/cannon_fire/frame_4.png")};
    private static final class_2960[] DYED_FIRE_TEXTURES = new class_2960[]{BlastTravel.id("textures/entity/cannon_fire/dyed_frame_0.png"), BlastTravel.id("textures/entity/cannon_fire/dyed_frame_1.png"), BlastTravel.id("textures/entity/cannon_fire/dyed_frame_2.png"), BlastTravel.id("textures/entity/cannon_fire/dyed_frame_3.png"), BlastTravel.id("textures/entity/cannon_fire/dyed_frame_4.png")};
    private static final class_2960[] SMOKE_TEXTURES = new class_2960[]{BlastTravel.id("textures/entity/cannon_smoke/frame_0.png"), BlastTravel.id("textures/entity/cannon_smoke/frame_1.png"), BlastTravel.id("textures/entity/cannon_smoke/frame_2.png"), BlastTravel.id("textures/entity/cannon_smoke/frame_3.png"), BlastTravel.id("textures/entity/cannon_smoke/frame_4.png")};
    private final class_630 root;
    private final class_630 leftWheel;
    private final class_630 rightWheel;
    private final class_630 cannon;
    private final class_630 chains;
    private final class_630 fuse;
    private final class_630 playerHead;
    private final class_630 fire;

    public CannonEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.root = context.method_32167(MODEL).method_32086("main");
        this.leftWheel = this.root.method_32086("left_wheel");
        this.rightWheel = this.root.method_32086("right_wheel");
        this.cannon = this.root.method_32086("cannon");
        this.playerHead = this.root.method_32086("player_head");
        this.fire = this.root.method_32086("fire");
        this.chains = this.cannon.method_32086("chains");
        this.fuse = this.cannon.method_32086("fuse");
        this.resetModel();
    }

    private void resetModel() {
        this.rightWheel.field_3654 = 0.0f;
        this.leftWheel.field_3654 = 0.0f;
        this.cannon.field_3654 = 0.0f;
        this.cannon.field_3665 = true;
        this.playerHead.field_3665 = false;
        this.fuse.field_3665 = true;
        this.chains.field_3665 = false;
        this.fire.field_3665 = false;
    }

    public class_2960 getTexture(CannonEntity entity) {
        return entity.getBehavior().texture(entity.getBehaviorStack());
    }

    public void render(CannonEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        boolean renderCannon;
        float wheelAngle;
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        matrices.method_22903();
        CannonBehavior behavior = entity.getBehavior();
        yaw = (180.0f + yaw) * ((float)Math.PI / 180);
        this.leftWheel.field_3654 = wheelAngle = yaw * 1.2f;
        this.rightWheel.field_3654 = -wheelAngle;
        this.cannon.field_3654 = (entity.method_5695(tickDelta) + 90.0f) * ((float)Math.PI / 180);
        this.cannon.field_3665 = renderCannon = entity.method_31483() != class_310.method_1551().field_1724 || class_310.method_1551().field_1773.method_19418().method_19333();
        this.chains.field_3665 = entity.hasChains();
        this.fuse.field_3665 = entity.hasFuse();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotation(yaw));
        float anim = entity.getAnimation(tickDelta);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-5.0f * (-2.0f * (anim * anim * anim * anim * anim * anim * anim * anim) + 2.0f * (anim * anim))));
        this.root.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)this.getTexture(entity))), light, class_4608.field_21444);
        Vector3f color = behavior.fireColor(entity);
        int tick = Math.max(0, 12 - entity.getAnimationTick() - 3);
        if (tick <= 7) {
            this.fire.field_3665 = true;
            this.fire.field_3654 = this.cannon.field_3654;
        }
        if (tick <= 4) {
            if (color != null) {
                this.fire.method_22699(matrices, vertexConsumers.getBuffer(class_1921.method_23026((class_2960)DYED_FIRE_TEXTURES[tick])), light, class_4608.field_21444, color.x, color.y, color.z, 1.0f);
            } else {
                this.fire.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23026((class_2960)FIRE_TEXTURES[tick])), light, class_4608.field_21444);
            }
        }
        if ((tick -= 3) >= 0 && tick <= 4) {
            this.fire.method_22699(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)SMOKE_TEXTURES[tick])), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.9f - 0.07f * (float)tick);
        }
        if (renderCannon && behavior.displayHead(entity)) {
            this.playerHead.field_3665 = true;
            this.playerHead.field_3654 = this.cannon.field_3654;
            color = behavior.headColor(entity);
            this.playerHead.method_22699(matrices, vertexConsumers.getBuffer(class_1921.method_23578((class_2960)behavior.headTexture(entity))), light, class_4608.field_21444, color.x, color.y, color.z, 1.0f);
        }
        this.resetModel();
        matrices.method_22909();
    }
}

