/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.blasttravel.entity;

import foundationgames.blasttravel.BlastTravel;
import foundationgames.blasttravel.entity.cannon.CannonBehavior;
import foundationgames.blasttravel.entity.cannon.ConcretePowderCannonBehavior;
import foundationgames.blasttravel.entity.cannon.EntityCannonBehavior;
import foundationgames.blasttravel.screen.CannonScreenHandler;
import foundationgames.blasttravel.util.BTNetworking;
import foundationgames.blasttravel.util.PlayerEntityDuck;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2777;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3908;
import net.minecraft.class_742;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.minecraft.ClientOnly;

public class CannonEntity
extends class_1297 {
    public static final class_2561 UI_TITLE = class_2561.method_43471((String)"container.blasttravel.cannon");
    public static final class_2561 NO_GUNPOWDER_DIALOG = class_2561.method_43471((String)"dialog.blasttravel.no_gunpowder").method_27692(class_124.field_1061);
    public static final class_2561 FULL_CANNON_DIALOG = class_2561.method_43471((String)"dialog.blasttravel.full_cannon").method_27692(class_124.field_1061);
    public static final CannonBehavior NONE = new CannonBehavior(class_1802.field_8162, stack -> false).register();
    public static final CannonBehavior GOLDEN = new CannonBehavior(class_1802.field_8494, BlastTravel.id("textures/entity/cannon/golden.png")).register();
    public static final CannonBehavior MOSSY = new CannonBehavior(class_1802.field_28654, BlastTravel.id("textures/entity/cannon/mossy.png")).register();
    public static final CannonBehavior LAZULI = new CannonBehavior(class_1802.field_8055, BlastTravel.id("textures/entity/cannon/lazuli.png")).register();
    public static final CannonBehavior AMETHYST = new CannonBehavior(class_1802.field_27064, BlastTravel.id("textures/entity/cannon/amethyst.png")).register();
    public static final CannonBehavior TNT = new EntityCannonBehavior(class_1802.field_8626, BlastTravel.id("textures/entity/cannon/tnt.png"), EntityCannonBehavior::tntFactory).register();
    public static final CannonBehavior ANVIL = new EntityCannonBehavior(class_1802.field_8782, s -> s.method_31573(class_3489.field_15547), BlastTravel.id("textures/entity/cannon/anvil.png"), EntityCannonBehavior::fallingBlockFactory).register();
    public static final CannonBehavior POWDER = new ConcretePowderCannonBehavior().register();
    public static final class_2940<Integer> BEHAVIOR = class_2945.method_12791(CannonEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> CHAINED = class_2945.method_12791(CannonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_1799> BEHAVIOR_STACK = class_2945.method_12791(CannonEntity.class, BlastTravel.ITEM_STACK_HANDLER);
    public static final int MAX_ANIMATION = 12;
    private boolean chained;
    private boolean firing;
    private boolean powered;
    private boolean alwaysModifiable;
    private int animation = 0;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int targetTicks;
    private final class_1277 inventory = new class_1277(3){

        public void method_5447(int slot, class_1799 stack) {
            super.method_5447(slot, stack);
            CannonEntity.this.updateStateFromInventory();
        }
    };

    public CannonEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public CannonEntity(class_1937 world) {
        this(BlastTravel.CANNON, world);
    }

    public void method_5773() {
        class_1297 class_12972;
        if (this.firing && !this.method_5782()) {
            this.firing = false;
        }
        super.method_5773();
        if (!this.chained && (class_12972 = this.method_31483()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.method_36456(player.method_5791());
            this.method_36457(player.method_36455());
        }
        if ((Boolean)this.field_6011.method_12789(CHAINED) != this.chained) {
            if (!this.method_37908().method_8608()) {
                this.field_6011.method_12778(CHAINED, (Object)this.chained);
            } else {
                this.setChained((Boolean)this.field_6011.method_12789(CHAINED));
            }
        }
        if (this.animation > 0) {
            --this.animation;
        }
        if (this.method_37908().method_8608()) {
            if (this.hasFuse()) {
                class_243 pos = this.method_19538().method_1031(0.0, 0.75, 0.0).method_1019(this.method_5631(this.method_36455() - 90.0f, this.method_36454()).method_1021(0.75));
                class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            }
            this.positionTrackTick();
        } else {
            boolean hasPower;
            boolean bl = hasPower = this.method_37908().method_49804(this.method_24515()) > 0 || this.method_37908().method_49804(this.method_24515().method_10074()) > 0;
            if (hasPower != this.powered) {
                if (hasPower) {
                    this.fireServer();
                }
                this.powered = hasPower;
            }
            this.movementTick();
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
    }

    public void method_5644(class_1297 passenger) {
        class_1657 player;
        if (this.method_37908().method_8608() && passenger instanceof class_1657 && (player = (class_1657)passenger).method_7340()) {
            if (this.chained) {
                player.method_36456(this.method_36454());
                player.method_36457(this.method_36455());
            } else {
                player.method_36457(Math.min(18.0f, player.method_36455()));
            }
        }
    }

    public boolean canPlayerModify(class_1657 player) {
        return this.alwaysModifiable || player.method_7294();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player == this.method_31483()) {
            return super.method_5688(player, hand);
        }
        if (player.method_5715()) {
            if (!this.method_37908().method_8608()) {
                if (this.canPlayerModify(player)) {
                    player.method_17355((class_3908)new class_747((syncId, playerInv, user) -> new CannonScreenHandler(syncId, playerInv, (class_1263)this.inventory), UI_TITLE));
                } else {
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14731, class_3419.field_15245, 0.5f, 1.5f);
                }
                return class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        if (!this.method_5782() && !this.getBehavior().occupiesCannon(this.inventory.method_5438(2))) {
            if (!this.method_37908().method_8608()) {
                player.method_36456(this.method_36454());
                player.method_36457(this.method_36455());
                player.method_5804((class_1297)this);
                return class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        player.method_7353(FULL_CANNON_DIALOG, true);
        return super.method_5688(player, hand);
    }

    public boolean method_5698(class_1297 attacker) {
        class_1657 player;
        if (attacker instanceof class_1657 && (player = (class_1657)attacker) != this.method_31483() && player.method_7294() && (player.method_7337() || player.method_5998(class_1268.field_5808).method_7909() instanceof class_1810)) {
            if (!this.method_37908().method_8608()) {
                class_1264.method_5451((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1263)this.inventory);
                if (!player.method_7337()) {
                    class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)new class_1799((class_1935)BlastTravel.CANNON_ITEM));
                }
                this.method_5650(class_1297.class_5529.field_26998);
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15026, class_3419.field_15245, 1.0f, 0.8f);
            this.method_37908().method_31595(this.method_24515(), class_2246.field_10535.method_9564());
            return true;
        }
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14658, class_3419.field_15245, 1.0f, 0.5f);
        return true;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        if (!this.method_37908().method_8608()) {
            this.method_5814(x, y, z);
            if (!this.method_5782()) {
                this.method_5710(yaw, pitch);
            }
        } else {
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
            this.targetTicks = this.method_5864().method_18388();
        }
    }

    private void positionTrackTick() {
        if (this.targetTicks > 0) {
            this.method_5814(this.method_23317() + (this.targetX - this.method_23317()) / (double)this.targetTicks, this.method_23318() + (this.targetY - this.method_23318()) / (double)this.targetTicks, this.method_23321() + (this.targetZ - this.method_23321()) / (double)this.targetTicks);
            --this.targetTicks;
        }
    }

    private void movementTick() {
        class_243 vel = this.method_18798();
        this.method_18799(new class_243(vel.field_1352 * 0.9, this.method_24828() ? 0.0 : Math.max(vel.field_1351 - 0.07, -0.7), vel.field_1350 * 0.9));
        this.field_6037 = true;
    }

    public class_1799 getBehaviorStack() {
        if (!this.method_37908().method_8608()) {
            return this.inventory.method_5438(2);
        }
        return (class_1799)this.field_6011.method_12789(BEHAVIOR_STACK);
    }

    public void handleInput(boolean firing) {
        if (this.method_37908().method_8608()) {
            if (firing && !this.firing) {
                BTNetworking.c2sRequestFire(this);
            }
            this.firing = firing;
        }
    }

    public void fireServer() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_1799 gunpowder = this.inventory.method_5438(0);
            if (gunpowder.method_31574(class_1802.field_8054) && gunpowder.method_7947() > 0) {
                class_1657 firedPlayer = null;
                class_1799 behaviorStack = this.getBehaviorStack();
                class_243 vel = this.method_18798().method_1019(this.method_5720().method_1021(Math.sqrt(gunpowder.method_7947()) * 0.6));
                this.getBehavior().onFired(this, behaviorStack, vel);
                class_1297 class_12972 = this.method_31483();
                if (class_12972 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    player.method_5848();
                    player.method_18799(vel);
                    ((class_3222)player).field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                    ((class_3222)player).field_13987.method_14364((class_2596)new class_2777((class_1297)player));
                    player.field_6037 = true;
                    ((PlayerEntityDuck)player).blasttravel$setCannonFlight(true);
                    firedPlayer = player;
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
                for (class_3222 to : world.method_18456()) {
                    BTNetworking.s2cFireCannon(to, this, firedPlayer, vel);
                }
                this.updateStateFromInventory();
            } else {
                class_1297 class_12973 = this.method_31483();
                if (class_12973 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12973;
                    player.method_5848();
                    player.method_7353(NO_GUNPOWDER_DIALOG, true);
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15222, class_3419.field_15245, 1.0f, 0.8f);
            }
        }
    }

    public void fireClient() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        this.animate();
        int ringParticles = 18;
        for (int i = 0; i < 18; ++i) {
            double angle = 0.3490658503988659 * (double)i;
            class_243 arc = new class_243(Math.sin(angle), Math.cos(angle), 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 pos = this.method_19538().method_1031(0.0, 0.75, 0.0).method_1019(this.method_5631(this.method_36455() - 4.0f, this.method_36454()).method_1021((double)1.69f)).method_1019(arc.method_1021((double)0.15f));
            class_243 vel = arc.method_1021(0.14);
            class_310.method_1551().field_1713.method_3056((class_2394)BlastTravel.CANNON_BLAST, pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
        }
    }

    public void animate() {
        this.animation = 12;
    }

    protected int getBehaviorId() {
        return (Integer)this.field_6011.method_12789(BEHAVIOR);
    }

    protected void setBehaviorId(int id) {
        this.field_6011.method_12778(BEHAVIOR, (Object)id);
    }

    public boolean hasFuse() {
        return this.method_5782() || this.getBehavior().occupiesCannon(this.inventory.method_5438(2));
    }

    public boolean hasChains() {
        return this.chained;
    }

    public float getAnimation(float tickDelta) {
        float anim = Math.max(0.0f, (float)this.animation - tickDelta);
        return anim / 12.0f;
    }

    public int getAnimationTick() {
        return this.animation;
    }

    private void setChained(boolean chained) {
        if (chained != this.chained) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15191, class_3419.field_15245, 1.0f, 1.2f);
        }
        this.chained = chained;
    }

    @ClientOnly
    @Nullable
    public class_742 getClientPlayer() {
        class_742 player;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_742 ? (player = (class_742)class_12972) : null;
    }

    public CannonBehavior getBehavior() {
        return CannonBehavior.byId(this.getBehaviorId());
    }

    protected void updateStateFromInventory() {
        if (!this.method_37908().method_8608()) {
            for (int slot = 0; slot < this.inventory.method_5439(); ++slot) {
                class_1799 stack = this.inventory.method_5438(slot);
                if (slot == 1) {
                    this.setChained(stack.method_31574(class_1802.field_23983));
                    continue;
                }
                if (slot != 2) continue;
                this.setBehaviorId(CannonBehavior.idForStack(stack));
                this.field_6011.method_12778(BEHAVIOR_STACK, (Object)stack);
            }
        }
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)BlastTravel.CANNON_ITEM);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30949(class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !this.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public double method_5621() {
        if (this.method_5782()) {
            class_1297 passenger = this.method_31483();
            return -passenger.method_5678() - (double)passenger.method_18381(passenger.method_18376()) + 0.75;
        }
        return super.method_5621();
    }

    protected void method_5693() {
        this.field_6011.method_12784(BEHAVIOR, (Object)0);
        this.field_6011.method_12784(CHAINED, (Object)false);
        this.field_6011.method_12784(BEHAVIOR_STACK, (Object)class_1799.field_8037);
    }

    protected void method_5749(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt.method_10562("Items"), (class_2371)this.inventory.field_5828);
        this.powered = nbt.method_10577("powered");
        this.alwaysModifiable = nbt.method_10577("alwaysModifiable");
        this.updateStateFromInventory();
    }

    protected void method_5652(class_2487 nbt) {
        class_2487 inv = new class_2487();
        class_1262.method_5426((class_2487)inv, (class_2371)this.inventory.field_5828);
        nbt.method_10566("Items", (class_2520)inv);
        nbt.method_10556("powered", this.powered);
        nbt.method_10556("alwaysModifiable", this.alwaysModifiable);
    }
}

