/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.blasttravel.entity.cannon;

import foundationgames.blasttravel.BlastTravel;
import foundationgames.blasttravel.entity.CannonEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.quiltmc.loader.api.minecraft.ClientOnly;

public class CannonBehavior {
    protected static final Vector3f WHITE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final List<CannonBehavior> ID_TO_BEHAVIOR = new ArrayList<CannonBehavior>();
    private static final Object2IntMap<Predicate<class_1799>> FILTER_TO_BEHAVIOR_ID = new Object2IntOpenHashMap();
    public final class_1792 icon;
    public final Predicate<class_1799> filter;
    private final class_2960 texture;

    public CannonBehavior(class_1792 item, class_2960 texture) {
        this(item, stack -> stack.method_7909() == item, texture);
    }

    public CannonBehavior(class_1792 icon, Predicate<class_1799> filter) {
        this(icon, filter, BlastTravel.id("textures/entity/cannon/regular.png"));
    }

    public CannonBehavior(class_1792 icon, Predicate<class_1799> filter, class_2960 texture) {
        this.icon = icon;
        this.filter = filter;
        this.texture = texture;
    }

    public CannonBehavior register() {
        FILTER_TO_BEHAVIOR_ID.put(this.filter, ID_TO_BEHAVIOR.size());
        ID_TO_BEHAVIOR.add(this);
        return this;
    }

    @ClientOnly
    public boolean displayHead(CannonEntity entity) {
        return entity.getClientPlayer() != null;
    }

    public boolean occupiesCannon(class_1799 behaviorStack) {
        return false;
    }

    public void onFired(CannonEntity cannon, class_1799 behaviorStack, class_243 velocity) {
    }

    public static CannonBehavior byId(int id) {
        return ID_TO_BEHAVIOR.get(id);
    }

    public static int idForStack(class_1799 stack) {
        for (Object2IntMap.Entry e : FILTER_TO_BEHAVIOR_ID.object2IntEntrySet()) {
            if (!((Predicate)e.getKey()).test(stack)) continue;
            return e.getIntValue();
        }
        return 0;
    }

    public static boolean isValidBehaviorStack(class_1799 stack) {
        return FILTER_TO_BEHAVIOR_ID.object2IntEntrySet().stream().anyMatch(e -> ((Predicate)e.getKey()).test(stack));
    }

    public static Collection<CannonBehavior> allBehaviors() {
        return ID_TO_BEHAVIOR;
    }

    @ClientOnly
    public class_2960 texture(class_1799 stack) {
        return this.texture;
    }

    @ClientOnly
    public class_2960 headTexture(CannonEntity entity) {
        class_742 player = entity.getClientPlayer();
        if (player == null) {
            return new class_2960("missing");
        }
        return player.method_3117();
    }

    @ClientOnly
    public Vector3f headColor(CannonEntity entity) {
        return WHITE;
    }

    @ClientOnly
    @Nullable
    public Vector3f fireColor(CannonEntity entity) {
        return null;
    }
}

