/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.content.entity;

import com.leisuretimedock.blasttravelreborn.BlastTravelReborn;
import com.leisuretimedock.blasttravelreborn.api.events.CannonFireEvent;
import com.leisuretimedock.blasttravelreborn.content.BTRParticleTypes;
import com.leisuretimedock.blasttravelreborn.content.entity.BTREntityTypes;
import com.leisuretimedock.blasttravelreborn.content.entity.cannon.CannonBehavior;
import com.leisuretimedock.blasttravelreborn.content.entity.cannon.ConcretePowderCannonBehavior;
import com.leisuretimedock.blasttravelreborn.content.entity.cannon.EntityCannonBehavior;
import com.leisuretimedock.blasttravelreborn.content.item.BTRItems;
import com.leisuretimedock.blasttravelreborn.content.menu.CannonContainerMenu;
import com.leisuretimedock.blasttravelreborn.network.BTRNetwork;
import com.leisuretimedock.blasttravelreborn.network.toClient.FireCannonPayload;
import com.leisuretimedock.blasttravelreborn.network.toServer.RequestFirePayload;
import com.leisuretimedock.blasttravelreborn.util.PlayerEntityDuck;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CannonEntity
extends Entity {
    public static final Component UI_TITLE = Component.m_237115_((String)"container.blasttravelreborn.cannon_container_menu");
    public static final Component NO_GUNPOWDER_DIALOG = Component.m_237115_((String)"dialog.blasttravelreborn.no_gunpowder").m_130940_(ChatFormatting.RED);
    public static final Component FULL_CANNON_DIALOG = Component.m_237115_((String)"dialog.blasttravelreborn.full_cannon").m_130940_(ChatFormatting.RED);
    public static final String ADD_GUNPOWDER_DIALOG = "dialog.blasttravelreborn.add_gunpowder_item";
    public static final String ADD_BEHAVIOR_DIALOG = "dialog.blasttravelreborn.add_behavior_item";
    public static final String ADD_LOCK_CHAIN_DIALOG = "dialog.blasttravelreborn.add_lock_chain_item";
    public static final String REMOVE_LOCK_CHAIN_DIALOG = "dialog.blasttravelreborn.remove_lock_chain_item";
    public static final Component FIRE = Component.m_237115_((String)"dialog.blasttravelreborn.fire").m_130940_(ChatFormatting.RED);
    public static final CannonBehavior NONE = new CannonBehavior(Items.f_41852_, stack -> false).register();
    public static final CannonBehavior GOLDEN = new CannonBehavior(Items.f_41912_, BlastTravelReborn.id("textures/entity/cannon/golden.png")).register();
    public static final CannonBehavior MOSSY = new CannonBehavior(Items.f_151016_, BlastTravelReborn.id("textures/entity/cannon/mossy.png")).register();
    public static final CannonBehavior LAZULI = new CannonBehavior(Items.f_41854_, BlastTravelReborn.id("textures/entity/cannon/lazuli.png")).register();
    public static final CannonBehavior AMETHYST = new CannonBehavior(Items.f_150998_, BlastTravelReborn.id("textures/entity/cannon/amethyst.png")).register();
    public static final CannonBehavior TNT = new EntityCannonBehavior(Items.f_41996_, BlastTravelReborn.id("textures/entity/cannon/tnt.png"), EntityCannonBehavior::tntFactory).register();
    public static final CannonBehavior ANVIL = new EntityCannonBehavior(Items.f_42146_, s -> s.m_204117_(ItemTags.f_13141_), BlastTravelReborn.id("textures/entity/cannon/anvil.png"), EntityCannonBehavior::fallingBlockFactory).register();
    public static final CannonBehavior POWDER = new ConcretePowderCannonBehavior().register();
    public static final CannonBehavior SAND = new EntityCannonBehavior(Items.f_41830_, BlastTravelReborn.id("blasttravelreborn", "textures/entity/cannon/sand.png"), EntityCannonBehavior::fallingBlockFactory).register();
    public static final CannonBehavior RED_SAND = new EntityCannonBehavior(Items.f_41831_, BlastTravelReborn.id("textures/entity/cannon/red_sand.png"), EntityCannonBehavior::fallingBlockFactory).register();
    public static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> CHAINED = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> BEHAVIOR_STACK = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final int MAX_ANIMATION = 12;
    private boolean chained;
    private boolean firing;
    private boolean powered;
    private boolean alwaysModifiable;
    private int animation = 0;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int targetTicks;
    private final SimpleContainer inventory = new SimpleContainer(3){

        public void m_6836_(int slot, @NotNull ItemStack stack) {
            super.m_6836_(slot, stack);
            CannonEntity.this.updateStateFromInventory();
        }
    };

    public CannonEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public CannonEntity(Level world) {
        this((EntityType)BTREntityTypes.CANNON_ENTITY.get(), world);
    }

    public void m_8119_() {
        Entity entity;
        if (this.firing && !this.m_20160_()) {
            this.firing = false;
        }
        super.m_8119_();
        if (!this.chained && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            this.m_146922_(player.m_6080_());
            this.m_146926_(player.m_146909_());
        }
        if ((Boolean)this.f_19804_.m_135370_(CHAINED) != this.chained) {
            if (!this.m_9236_().m_5776_()) {
                this.f_19804_.m_135381_(CHAINED, (Object)this.chained);
            } else {
                this.setChained((Boolean)this.f_19804_.m_135370_(CHAINED));
            }
        }
        if (this.animation > 0) {
            --this.animation;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.hasFuse()) {
                Vec3 pos = this.m_20182_().m_82520_(0.0, 0.75, 0.0).m_82549_(this.m_20171_(this.m_146909_() - 90.0f, this.m_146908_()).m_82490_(0.75));
                Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            this.positionTrackTick();
        } else {
            boolean hasPower;
            boolean bl = hasPower = this.m_9236_().m_277086_(this.m_20183_()) > 0 || this.m_9236_().m_277086_(this.m_20183_().m_7495_()) > 0;
            if (hasPower != this.powered) {
                if (hasPower) {
                    this.fireServer();
                }
                this.powered = hasPower;
            }
            this.movementTick();
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    public void m_7340_(@NotNull Entity passenger) {
        Player player;
        if (this.m_9236_().m_5776_() && passenger instanceof Player && (player = (Player)passenger).m_7578_()) {
            if (this.chained) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
            } else {
                player.m_146926_(Math.min(18.0f, player.m_146909_()));
            }
        }
    }

    public boolean canPlayerModify(Player player) {
        return this.alwaysModifiable || player.m_36326_();
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack handItem = player.m_21120_(hand);
        if (!player.m_6144_() && this.testAndInteract(player, handItem)) {
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (player == this.m_146895_()) {
            return super.m_6096_(player, hand);
        }
        if (player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                if (this.canPlayerModify(player)) {
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((syncId, playerInv, user) -> new CannonContainerMenu(syncId, playerInv, (Container)this.inventory), UI_TITLE));
                } else {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, 1.5f);
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_20160_() && !this.getBehavior().occupiesCannon(this.inventory.m_8020_(2))) {
            if (!this.m_9236_().m_5776_()) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                player.m_20329_((Entity)this);
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        player.m_5661_(FULL_CANNON_DIALOG, true);
        return super.m_6096_(player, hand);
    }

    private boolean testAndInteract(Player player, @NotNull ItemStack stack) {
        if (stack.m_150930_(Items.f_42403_)) {
            this.handlerGunPower(player, stack);
            return true;
        }
        if (stack.m_150930_(Items.f_42026_)) {
            this.handlerChain(player, stack);
            return true;
        }
        if (CannonBehavior.isValidBehaviorStack(stack) && this.m_20197_().isEmpty()) {
            this.handlerBehaviorItem(player, stack);
            return true;
        }
        if (stack.m_150930_(Items.f_42409_)) {
            player.m_5661_(FIRE, true);
            this.fireServer();
            return true;
        }
        return false;
    }

    private void handlerGunPower(Player player, ItemStack stack) {
        if (!this.m_9236_().m_5776_()) {
            ItemStack currentGunpowder = this.inventory.m_8020_(0);
            if (currentGunpowder.m_41613_() >= currentGunpowder.m_41741_() && !player.m_7500_() && !player.m_150109_().m_36054_(currentGunpowder)) {
                player.m_36176_(currentGunpowder, false);
            }
            ItemStack newGunpowder = stack.m_41777_();
            newGunpowder.m_41764_(currentGunpowder.m_41613_() + 1);
            player.m_5661_((Component)Component.m_237110_((String)ADD_GUNPOWDER_DIALOG, (Object[])new Object[]{Math.min(currentGunpowder.m_41613_() + 1, currentGunpowder.m_41741_()), currentGunpowder.m_41741_()}), true);
            this.inventory.m_6836_(0, newGunpowder);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12334_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void handlerChain(Player player, ItemStack stack) {
        if (!this.m_9236_().m_5776_()) {
            ItemStack currentChain = this.inventory.m_8020_(1);
            if (currentChain.m_41619_()) {
                ItemStack item = stack.m_41777_();
                item.m_41764_(1);
                this.inventory.m_6836_(1, item);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_5661_((Component)Component.m_237115_((String)ADD_LOCK_CHAIN_DIALOG).m_130940_(ChatFormatting.GREEN), true);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.inventory.m_6836_(1, ItemStack.f_41583_);
                if (!player.m_7500_() && !player.m_150109_().m_36054_(currentChain)) {
                    player.m_36176_(currentChain, false);
                }
                player.m_5661_((Component)Component.m_237115_((String)REMOVE_LOCK_CHAIN_DIALOG).m_130940_(ChatFormatting.RED), true);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11743_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private void handlerBehaviorItem(Player player, ItemStack stack) {
        if (!this.m_9236_().m_5776_()) {
            ItemStack currentBehaviorItem = this.inventory.m_8020_(2);
            if (currentBehaviorItem.m_41619_()) {
                ItemStack copied = stack.m_41777_();
                copied.m_41764_(1);
                this.inventory.m_6836_(2, copied);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), this.getBehavior().getPlaceInSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                if (stack.m_150930_(currentBehaviorItem.m_41720_())) {
                    if (currentBehaviorItem.m_41613_() >= currentBehaviorItem.m_41741_() && !player.m_7500_() && !player.m_150109_().m_36054_(currentBehaviorItem)) {
                        player.m_36176_(currentBehaviorItem, false);
                    }
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(currentBehaviorItem.m_41613_() + 1);
                    player.m_5661_((Component)Component.m_237110_((String)ADD_BEHAVIOR_DIALOG, (Object[])new Object[]{Component.m_237115_((String)currentBehaviorItem.m_41778_()), Math.min(currentBehaviorItem.m_41613_() + 1, currentBehaviorItem.m_41741_()), currentBehaviorItem.m_41741_()}), true);
                    this.inventory.m_6836_(2, stack1);
                } else {
                    if (!player.m_7500_() && !player.m_150109_().m_36054_(currentBehaviorItem)) {
                        player.m_36176_(currentBehaviorItem, false);
                    }
                    ItemStack copied = stack.m_41777_();
                    copied.m_41764_(1);
                    this.inventory.m_6836_(2, copied);
                    player.m_5661_((Component)Component.m_237110_((String)ADD_BEHAVIOR_DIALOG, (Object[])new Object[]{Component.m_237115_((String)stack.m_41778_()), 1, stack.m_41741_()}), true);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), this.getBehavior().getPlaceInSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean m_7313_(@NotNull Entity attacker) {
        Player player;
        if (attacker instanceof Player && (player = (Player)attacker) != this.m_146895_()) {
            ItemStack is = player.m_21120_(InteractionHand.MAIN_HAND);
            if (player.m_36326_() && (player.m_7500_() || is.m_41720_() instanceof PickaxeItem)) {
                if (!this.m_9236_().m_5776_()) {
                    Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)this.inventory);
                    if (!player.m_7500_()) {
                        Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)new ItemStack((ItemLike)BTRItems.CANNON_ITEM.get()));
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 0.8f);
                this.m_9236_().m_142052_(this.m_20183_(), Blocks.f_50322_.m_49966_());
                return true;
            }
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, 0.5f);
        return true;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        if (!this.m_9236_().m_5776_()) {
            this.m_6034_(x, y, z);
            if (!this.m_20160_()) {
                this.m_19915_(yaw, pitch);
            }
        } else {
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
            this.targetTicks = this.m_6095_().m_20682_();
        }
    }

    private void positionTrackTick() {
        if (this.targetTicks > 0) {
            this.m_6034_(this.m_20185_() + (this.targetX - this.m_20185_()) / (double)this.targetTicks, this.m_20186_() + (this.targetY - this.m_20186_()) / (double)this.targetTicks, this.m_20189_() + (this.targetZ - this.m_20189_()) / (double)this.targetTicks);
            --this.targetTicks;
        }
    }

    private void movementTick() {
        Vec3 vel = this.m_20184_();
        this.m_20256_(new Vec3(vel.f_82479_ * 0.9, this.m_20096_() ? 0.0 : Math.max(vel.f_82480_ - 0.07, -0.7), vel.f_82481_ * 0.9));
        this.f_19864_ = true;
    }

    public ItemStack getBehaviorStack() {
        if (!this.m_9236_().m_5776_()) {
            return this.inventory.m_8020_(2);
        }
        return (ItemStack)this.f_19804_.m_135370_(BEHAVIOR_STACK);
    }

    public void handleInput(boolean firing) {
        if (this.m_9236_().m_5776_()) {
            if (firing && !this.firing) {
                BTRNetwork.CHANNEL.sendToServer((Object)new RequestFirePayload(this));
            }
            this.firing = firing;
        }
    }

    public void fireServer() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            ItemStack gunpowder = this.inventory.m_8020_(0);
            if (gunpowder.m_150930_(Items.f_42403_) && gunpowder.m_41613_() > 0) {
                CannonFireEvent.Pre pre;
                Player firedPlayer = null;
                ItemStack behaviorStack = this.getBehaviorStack();
                Entity entity = this.m_146895_();
                if (entity instanceof Player) {
                    Player player;
                    firedPlayer = player = (Player)entity;
                }
                if ((pre = new CannonFireEvent.Pre(this, firedPlayer, behaviorStack)).isCanceled()) {
                    return;
                }
                Vec3 vel = this.m_20184_().m_82549_(this.m_20154_().m_82490_(Math.sqrt(gunpowder.m_41613_()) * 0.6));
                CannonBehavior behavior = this.getBehavior();
                if (firedPlayer != null) {
                    firedPlayer.m_20256_(vel);
                    firedPlayer.f_19864_ = true;
                    firedPlayer.m_8127_();
                    ((PlayerEntityDuck)firedPlayer).blasttravel$setCannonFlight(true);
                }
                if (pre.isCanceled()) {
                    return;
                }
                behavior.onFired(this, behaviorStack, vel);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (ServerPlayer to : world.m_6907_()) {
                    BTRNetwork.CHANNEL.sendTo((Object)new FireCannonPayload(this, firedPlayer, vel), to.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                this.updateStateFromInventory();
            } else {
                Entity entity = this.m_146895_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_8127_();
                    player.m_5661_(NO_GUNPOWDER_DIALOG, true);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 0.8f);
            }
        }
    }

    public void fireClient() {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        this.animate();
        int ringParticles = 18;
        for (int i = 0; i < 18; ++i) {
            double angle = 0.3490658503988659 * (double)i;
            Vec3 arc = new Vec3(Math.sin(angle), Math.cos(angle), 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 pos = this.m_20182_().m_82520_(0.0, 0.75, 0.0).m_82549_(this.m_20171_(this.m_146909_() - 4.0f, this.m_146908_()).m_82490_((double)1.69f)).m_82549_(arc.m_82490_((double)0.15f));
            Vec3 vel = arc.m_82490_(0.14);
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)BTRParticleTypes.CANNON_BLAST.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    public void animate() {
        this.animation = 12;
    }

    protected int getBehaviorId() {
        return (Integer)this.f_19804_.m_135370_(BEHAVIOR);
    }

    protected void setBehaviorId(int id) {
        this.f_19804_.m_135381_(BEHAVIOR, (Object)id);
    }

    public boolean hasFuse() {
        return this.m_20160_() || this.getBehavior().occupiesCannon(this.inventory.m_8020_(2));
    }

    public boolean hasChains() {
        return this.chained;
    }

    public float getAnimation(float tickDelta) {
        float anim = Math.max(0.0f, (float)this.animation - tickDelta);
        return anim / 12.0f;
    }

    public int getAnimationTick() {
        return this.animation;
    }

    private void setChained(boolean chained) {
        if (chained != this.chained) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11672_, SoundSource.BLOCKS, 1.0f, 1.2f);
        }
        this.chained = chained;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AbstractClientPlayer getClientPlayer() {
        AbstractClientPlayer player;
        Entity entity = this.m_146895_();
        return entity instanceof AbstractClientPlayer ? (player = (AbstractClientPlayer)entity) : null;
    }

    public CannonBehavior getBehavior() {
        return CannonBehavior.byId(this.getBehaviorId());
    }

    protected void updateStateFromInventory() {
        if (!this.m_9236_().m_5776_()) {
            for (int slot = 0; slot < this.inventory.m_6643_(); ++slot) {
                ItemStack stack = this.inventory.m_8020_(slot);
                if (slot == 1) {
                    this.setChained(stack.m_150930_(Items.f_42026_));
                    continue;
                }
                if (slot != 2) continue;
                this.setBehaviorId(CannonBehavior.idForStack(stack));
                this.f_19804_.m_135381_(BEHAVIOR_STACK, (Object)stack);
            }
        }
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)BTRItems.CANNON_ITEM.get());
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_7337_(Entity other) {
        return (other.m_5829_() || other.m_6094_()) && !this.m_20365_(other);
    }

    public boolean m_5829_() {
        return true;
    }

    public double m_6048_() {
        Entity passenger;
        if (this.m_20160_() && (passenger = this.m_146895_()) != null) {
            return -passenger.m_6049_() - (double)passenger.m_20236_(passenger.m_20089_()) + 0.75;
        }
        return super.m_6048_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BEHAVIOR, (Object)0);
        this.f_19804_.m_135372_(CHAINED, (Object)false);
        this.f_19804_.m_135372_(BEHAVIOR_STACK, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Items"), (NonNullList)this.inventory.f_19147_);
        this.powered = nbt.m_128471_("powered");
        this.alwaysModifiable = nbt.m_128471_("alwaysModifiable");
        this.updateStateFromInventory();
    }

    protected void m_7380_(CompoundTag nbt) {
        CompoundTag inv = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inv, (NonNullList)this.inventory.f_19147_);
        nbt.m_128365_("Items", (Tag)inv);
        nbt.m_128379_("powered", this.powered);
        nbt.m_128379_("alwaysModifiable", this.alwaysModifiable);
    }
}

