/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.content.entity.cannon;

import com.leisuretimedock.blasttravelreborn.BlastTravelReborn;
import com.leisuretimedock.blasttravelreborn.api.events.CannonFireEvent;
import com.leisuretimedock.blasttravelreborn.content.entity.CannonEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CannonBehavior {
    protected static final Vector3f WHITE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final List<CannonBehavior> ID_TO_BEHAVIOR = new ArrayList<CannonBehavior>();
    private static final Object2IntMap<Predicate<ItemStack>> FILTER_TO_BEHAVIOR_ID = new Object2IntOpenHashMap();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private SoundEvent placeInSound = SoundEvents.f_12334_;
    private SoundEvent takeOutSound = SoundEvents.f_271165_;
    public final Item icon;
    public final Predicate<ItemStack> filter;
    private final ResourceLocation texture;

    public CannonBehavior(Item item, ResourceLocation texture) {
        this(item, stack -> stack.m_41720_() == item, texture);
    }

    public CannonBehavior(Item icon, Predicate<ItemStack> filter) {
        this(icon, filter, BlastTravelReborn.id("textures/entity/cannon/regular.png"));
    }

    public CannonBehavior(Item icon, Predicate<ItemStack> filter, ResourceLocation texture) {
        this.icon = icon;
        this.filter = filter;
        this.texture = texture;
    }

    public void setPlaceInSound(SoundEvent placeInSound) {
        this.placeInSound = placeInSound;
    }

    public SoundEvent getPlaceInSound() {
        return this.placeInSound;
    }

    public SoundEvent getTakeOutSound() {
        return this.takeOutSound;
    }

    public void setTakeOutSound(SoundEvent takeOutSound) {
        this.takeOutSound = takeOutSound;
    }

    public CannonBehavior register() {
        if (!this.registered.get()) {
            FILTER_TO_BEHAVIOR_ID.put(this.filter, ID_TO_BEHAVIOR.size());
            ID_TO_BEHAVIOR.add(this);
            this.registered.set(true);
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean displayHead(@NotNull CannonEntity entity) {
        return entity.getClientPlayer() != null;
    }

    public boolean occupiesCannon(ItemStack behaviorStack) {
        return false;
    }

    public void onFired(@NotNull CannonEntity cannon, ItemStack behaviorStack, Vec3 velocity) {
        Entity firstPassenger = cannon.m_146895_();
        Player player = null;
        if (firstPassenger instanceof Player) {
            Player player1;
            player = player1 = (Player)firstPassenger;
        }
        MinecraftForge.EVENT_BUS.post((Event)new CannonFireEvent.Post(cannon, player, behaviorStack, cannon.m_20182_(), velocity));
    }

    public static CannonBehavior byId(int id) {
        return ID_TO_BEHAVIOR.get(id);
    }

    public static int idForStack(ItemStack stack) {
        for (Object2IntMap.Entry e : FILTER_TO_BEHAVIOR_ID.object2IntEntrySet()) {
            if (!((Predicate)e.getKey()).test(stack)) continue;
            return e.getIntValue();
        }
        return 0;
    }

    public static boolean isValidBehaviorStack(ItemStack stack) {
        return FILTER_TO_BEHAVIOR_ID.object2IntEntrySet().stream().anyMatch(e -> ((Predicate)e.getKey()).test(stack));
    }

    public static Collection<CannonBehavior> allBehaviors() {
        return ID_TO_BEHAVIOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation texture(ItemStack stack) {
        return this.texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation headTexture(CannonEntity entity) {
        AbstractClientPlayer player = entity.getClientPlayer();
        if (player == null) {
            return new ResourceLocation("missing");
        }
        return player.m_108560_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f headColor(CannonEntity entity) {
        return WHITE;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vector3f fireColor(CannonEntity entity) {
        return null;
    }
}

