/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.content.entity.cannon;

import com.leisuretimedock.blasttravelreborn.content.entity.CannonEntity;
import com.leisuretimedock.blasttravelreborn.content.entity.cannon.CannonBehavior;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityCannonBehavior
extends CannonBehavior {
    private final EntityFactory entityFactory;

    public EntityCannonBehavior(Item item, ResourceLocation texture, EntityFactory entityFactory) {
        this(item, stack -> stack.m_150930_(item), texture, entityFactory);
    }

    public EntityCannonBehavior(Item icon, Predicate<ItemStack> filter, ResourceLocation texture, EntityFactory entityFactory) {
        super(icon, filter, texture);
        this.entityFactory = entityFactory;
    }

    @Override
    public boolean occupiesCannon(ItemStack behaviorStack) {
        return true;
    }

    @Override
    public void onFired(@NotNull CannonEntity cannon, ItemStack behaviorStack, Vec3 velocity) {
        super.onFired(cannon, behaviorStack, velocity);
        Vec3 pos = cannon.m_20182_().m_82520_(0.0, 0.75, 0.0).m_82549_(cannon.m_20154_().m_82490_(1.8));
        Entity entity = this.entityFactory.create(cannon.m_9236_(), pos, behaviorStack);
        entity.m_20256_(velocity);
        behaviorStack.m_41774_(1);
        cannon.m_9236_().m_7967_(entity);
    }

    public static Entity tntFactory(Level world, Vec3 pos, ItemStack from) {
        return new PrimedTnt(world, pos.f_82479_, pos.f_82480_ - 0.5, pos.f_82481_, null);
    }

    public static Entity fallingBlockFactory(Level world, Vec3 pos, ItemStack from) {
        BlockState blockState;
        double d = pos.f_82479_;
        double d2 = pos.f_82480_ - 0.5;
        double d3 = pos.f_82481_;
        Item item = from.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem block = (BlockItem)item;
            blockState = block.m_40614_().m_49966_();
        } else {
            blockState = Blocks.f_50016_.m_49966_();
        }
        return new FallingBlockEntity(world, d, d2, d3, blockState);
    }

    @FunctionalInterface
    public static interface EntityFactory {
        public Entity create(Level var1, Vec3 var2, ItemStack var3);
    }
}

