/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.datagen;

import com.leisuretimedock.blasttravelreborn.datagen.BTRRegistries;
import com.leisuretimedock.blasttravelreborn.datagen.provider.BTRItemModelProvider;
import com.leisuretimedock.blasttravelreborn.datagen.provider.BTRParticleProvider;
import com.leisuretimedock.blasttravelreborn.datagen.provider.BTRRecipeProvider;
import com.leisuretimedock.blasttravelreborn.datagen.value.BTRLangKeys;
import java.util.Set;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.datagen.provider.SimpleLanguageProvider;
import top.r3944realms.lib39.datagen.value.ILangKeyValueCollection;
import top.r3944realms.lib39.datagen.value.McLocale;

public class DataGeneratorHandler {
    @SubscribeEvent
    public static void generatorDataEvent(GatherDataEvent event) {
        DataGeneratorHandler.LanguageGenerate(event, McLocale.EN_US);
        DataGeneratorHandler.LanguageGenerate(event, McLocale.ZH_CN);
        DataGeneratorHandler.LanguageGenerate(event, McLocale.ZH_TW);
        DataGeneratorHandler.ModelDataGenerate(event);
        DataGeneratorHandler.ParticleGenerate(event);
        DataGeneratorHandler.RecipeGenerate(event);
        DataGeneratorHandler.DatapackBuiltinEntriesGenerate(event);
    }

    private static void LanguageGenerate(@NotNull GatherDataEvent event, McLocale language) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new SimpleLanguageProvider(pOutput, "blasttravelreborn", language, (ILangKeyValueCollection)BTRLangKeys.INSTANCE));
    }

    private static void ModelDataGenerate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new BTRItemModelProvider(pOutput, event.getExistingFileHelper()));
    }

    private static void RecipeGenerate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), BTRRecipeProvider::new);
    }

    private static void ParticleGenerate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new BTRParticleProvider(pOutput, event.getExistingFileHelper()));
    }

    private static void DatapackBuiltinEntriesGenerate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), pOutput -> new DatapackBuiltinEntriesProvider(pOutput, event.getLookupProvider(), BTRRegistries.BUILDER, Set.of("blasttravelreborn")));
    }
}

