/*
 * Decompiled with CFR 0.152.
 */
package com.leisuretimedock.blasttravelreborn.mixin;

import com.leisuretimedock.blasttravelreborn.BlastTravelReborn;
import com.leisuretimedock.blasttravelreborn.api.events.PlayerCannonFlightTickEvent;
import com.leisuretimedock.blasttravelreborn.mixin.LivingEntityAccess;
import com.leisuretimedock.blasttravelreborn.network.BTRNetwork;
import com.leisuretimedock.blasttravelreborn.network.toClient.SyncFlightStatePayload;
import com.leisuretimedock.blasttravelreborn.network.toServer.StopCannonFlightServerPayload;
import com.leisuretimedock.blasttravelreborn.util.PlayerEntityDuck;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityDuck {
    @Unique
    private static final EntityDimensions CANNON_FLIGHT_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
    @Unique
    private Vec3 blasttravel$vel = Vec3.f_82478_;
    @Unique
    private Vec3 blasttravel$trackingVel = Vec3.f_82478_;
    @Unique
    private Vec3 blasttravel$prevVel = Vec3.f_82478_;
    @Unique
    private boolean blasttravel$inCannonFlight = false;
    @Unique
    private boolean blasttravel$cancelFallDamage = false;
    @Unique
    private int blasttravel$ticksFlying = 0;

    @Shadow
    public abstract boolean m_7578_();

    @Shadow
    public abstract Abilities m_150110_();

    @Shadow
    public abstract boolean m_5833_();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void blasttravel$beginTick(CallbackInfo ci) {
        this.blasttravel$prevVel = this.m_7578_() ? this.blasttravel$vel : this.blasttravel$trackingVel;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void blasttravel$endTick(CallbackInfo ci) {
        PlayerEntityMixin self = this;
        this.blasttravel$vel = self.m_20182_().m_82492_(self.f_19854_, self.f_19855_, self.f_19856_);
        if (this.blasttravel$inCannonFlight()) {
            this.f_19794_ = true;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerCannonFlightTickEvent((Entity)self, this.blasttravel$vel, self.m_20182_(), this.blasttravel$ticksFlying));
            if (!self.m_9236_().m_5776_()) {
                Vec3 vel = self.m_20184_();
                AABB frontBox = self.m_20191_().m_82363_(0.2, 0.2, 0.2);
                for (LivingEntity entity2 : self.m_9236_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), frontBox, entity -> entity != self)) {
                    if (entity2.m_20147_()) continue;
                    DamageSource source = self.m_269291_().m_269298_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)BlastTravelReborn.id("cannon")), (Entity)self);
                    entity2.m_6469_(source, (float)(vel.m_82553_() * 4.0));
                }
                if (this.blasttravel$ticksFlying < 5) {
                    try {
                        ServerPlayer cast = (ServerPlayer)ServerPlayer.class.cast(self);
                        BTRNetwork.CHANNEL.sendTo((Object)new SyncFlightStatePayload(self.m_19879_(), vel, self.m_20182_(), true, this.f_19794_), cast.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (self.m_7578_() && this.blasttravel$ticksFlying > 8 && (self.m_20096_() || self.m_21255_() || self.m_150110_().f_35935_ || self.m_5842_())) {
                this.blasttravel$setCannonFlight(false);
                BTRNetwork.CHANNEL.sendToServer((Object)new StopCannonFlightServerPayload(self.m_20096_()));
            }
            ++this.blasttravel$ticksFlying;
        } else {
            this.blasttravel$ticksFlying = 0;
            if (!self.m_5833_()) {
                this.f_19794_ = false;
            }
        }
        if (!self.m_7578_()) {
            this.blasttravel$trackingVel = this.blasttravel$trackingVel.m_82549_(this.blasttravel$vel.m_82546_(this.blasttravel$trackingVel).m_82490_((double)(1.0f / (float)self.m_6095_().m_20682_())));
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void blasttravel$cancelFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.blasttravel$cancelFallDamage) {
            this.blasttravel$cancelFallDamage = false;
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void blasttravel$setFlyingPose(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (this.blasttravel$inCannonFlight()) {
            cir.setReturnValue((Object)CANNON_FLIGHT_DIMENSIONS);
        }
    }

    @Inject(method={"getStandingEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void blasttravel$setFlyingEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        if (this.blasttravel$inCannonFlight()) {
            cir.setReturnValue((Object)Float.valueOf(dimensions.f_20378_ * 0.5f));
        }
    }

    @Override
    public void blasttravel$setCannonFlight(boolean inFlight) {
        PlayerEntityMixin self = this;
        if (inFlight && !this.blasttravel$inCannonFlight) {
            this.blasttravel$trackingVel = this.blasttravel$prevVel = self.m_20184_();
            this.blasttravel$vel = this.blasttravel$prevVel;
            this.blasttravel$cancelFallDamage = true;
            self.m_6862_(false);
        }
        this.blasttravel$inCannonFlight = inFlight;
        ((LivingEntityAccess)((Object)this)).blasttravel$setNoDrag(inFlight);
        self.m_6210_();
    }

    @Override
    public boolean blasttravel$inCannonFlight() {
        return this.blasttravel$inCannonFlight;
    }

    @Override
    public Vec3 blasttravel$getVelocityLerped(float delta) {
        Vec3 vel = this.m_7578_() ? this.blasttravel$vel : this.blasttravel$trackingVel;
        return new Vec3(Mth.m_14139_((double)delta, (double)this.blasttravel$prevVel.f_82479_, (double)vel.f_82479_), Mth.m_14139_((double)delta, (double)this.blasttravel$prevVel.f_82480_, (double)vel.f_82480_), Mth.m_14139_((double)delta, (double)this.blasttravel$prevVel.f_82481_, (double)vel.f_82481_));
    }
}

