/*
 * Decompiled with CFR 0.152.
 */
package net.zaills.wetland.worldgen.surfacebuilders;

import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import com.terraformersmc.biolith.impl.noise.OpenSimplexNoise2;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_4543;
import net.minecraft.class_5819;
import net.minecraft.class_6557;

public class WetlandSurfaceBuilder
extends BiolithSurfaceBuilder {
    private static final OpenSimplexNoise2 NOISE = new OpenSimplexNoise2(346987L);
    private final class_2680 waterMaterial;
    private final class_2680 landMaterial;
    private final class_2680 topMaterial;
    private final class_2680 airMaterial;
    private final class_2680 mossMaterial;

    public WetlandSurfaceBuilder(class_2680 waterMaterial, class_2680 landMaterial, class_2680 topMaterial, class_2680 airMaterial, class_2680 mossMaterial) {
        this.waterMaterial = waterMaterial;
        this.landMaterial = landMaterial;
        this.topMaterial = topMaterial;
        this.airMaterial = airMaterial;
        this.mossMaterial = mossMaterial;
    }

    public void generate(class_4543 biomeAccess, class_6557 column, class_5819 rand, class_2791 chunk, class_1959 biome, int x, int z, int vHeight, int seaLevel) {
        int y = vHeight = chunk.method_12005(class_2902.class_2903.field_13195, x & 0xF, z & 0xF);
        double waterHeight = NOISE.sample((double)x * 0.025, (double)z * 0.05) * 3.0f;
        double landHeight = -waterHeight;
        double mossNoise = NOISE.sample((double)x * 0.05, (double)z * 0.05) * 10.0f;
        int h = 0;
        while ((double)h < waterHeight) {
            column.method_38092(y, y < seaLevel ? this.waterMaterial : this.airMaterial);
            --y;
            ++h;
        }
        class_2680 landBlocks = this.landMaterial;
        class_2680 topBlocks = this.topMaterial;
        if (y > seaLevel) {
            landBlocks = this.airMaterial;
            topBlocks = this.airMaterial;
        }
        int h2 = 0;
        while ((double)h2 < landHeight) {
            column.method_38092(y, landBlocks);
            ++y;
            ++h2;
        }
        if (y >= seaLevel) {
            while (column.method_32892(y).method_26215()) {
                --y;
            }
            column.method_38092(y, topBlocks);
        }
        if (y < seaLevel + 3 && mossNoise > 4.0) {
            while (column.method_32892(y).method_26215() && column.method_32892(y).method_26204().equals(this.waterMaterial.method_26204())) {
                --y;
            }
            column.method_38092(y, this.mossMaterial);
        }
    }
}

