/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.gui.components;

import com.github.yukkuritaku.modernwarpmenu.client.gui.components.ScaleTransitionButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.ModernWarpScreen;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.grid.ScaledGrid;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.transition.ScaleTransition;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Island;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import java.awt.Color;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_9848;

public class IslandButton
extends ScaleTransitionButton {
    private static final Color TEXT_GREEN_COLOR = new Color(0x55FF55);
    private static final float HOVERED_SCALE = 1.1f;
    private static final long SCALE_TRANSITION_DURATION = 400L;
    public final Island island;
    public final ScaledGrid scaledGrid;

    public IslandButton(ModernWarpScreen parent, class_1041 window, Island island, class_4185.class_4241 onPress, class_4185.class_7841 createNarration) {
        super(island.gridX, island.gridY, island.getWidth(), island.getHeight(), (class_2561)class_2561.method_43470((String)island.name), island.texture, island.hoverEffectTexture, onPress, createNarration);
        this.island = island;
        this.island.init(window);
        this.scaledXPosition = parent.getScaledGrid().getActualX(island.gridX);
        this.scaledYPosition = parent.getScaledGrid().getActualY(island.gridY);
        this.setZLevel(island.zLevel);
        this.field_22758 = island.getWidth();
        this.field_22759 = island.getHeight();
        this.scaledGrid = new ScaledGrid(this.scaledXPosition, this.scaledYPosition, (float)this.field_22758, (float)this.field_22759, 40, true);
        this.transition = new ScaleTransition(0L, 1.0f, 1.0f);
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22764) {
            int originalZ = this.getZLevel();
            this.transitionStep(400L, 1.1f);
            this.scaledGrid.setScaleFactor(this.transition.getCurrentScale());
            this.scaledXPosition = this.scaledGrid.getGridStartX();
            this.scaledYPosition = this.scaledGrid.getGridStartY();
            this.scaledWidth = this.scaledGrid.getScaledDimension(this.field_22758);
            this.scaledHeight = this.scaledGrid.getScaledDimension(this.field_22759);
            if (this.field_22762) {
                this.setZLevel(9);
            }
            this.renderButtonTexture(guiGraphics, this.backgroundTexture.location());
            if (this.field_22762) {
                this.renderForegroundLayer(guiGraphics, this.foregroundTexture.location());
            }
            if (SettingsManager.get().general.showIslandLabels) {
                this.renderMessageString(guiGraphics, this.scaledWidth / 2.0f, this.scaledHeight, TEXT_GREEN_COLOR);
            }
            if (SettingsManager.get().debug.debugModeEnabled && SettingsManager.get().debug.drawBorders) {
                this.renderBorder(guiGraphics, class_9848.method_61317((float)1.0f));
            }
            this.setZLevel(originalZ);
        }
    }
}

