/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.gui.components;

import com.github.yukkuritaku.modernwarpmenu.client.gui.components.IslandButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.ScaleTransitionButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.grid.GridRectangle;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.transition.ScaleTransition;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Island;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class WarpButton
extends ScaleTransitionButton {
    private final IslandButton parent;
    private final Warp warp;
    private boolean drawWarpLabel;

    public WarpButton(IslandButton parent, Warp warp, class_4185.class_4241 onPress, class_4185.class_7841 createNarration) {
        super(warp.gridX(), warp.gridY(), Warp.getWidth(), Warp.getHeight(), (class_2561)class_2561.method_43470((String)warp.displayName()), warp.getWarpTextureLocation(), warp.getWarpHoverEffectTextureLocation(), onPress, createNarration);
        this.parent = parent;
        this.warp = warp;
        this.buttonRectangle = new GridRectangle(parent.scaledGrid, warp.gridX(), warp.gridY(), Warp.getWidth(), Warp.getHeight(), true, false);
        parent.scaledGrid.addRectangle(warp.displayName(), this.buttonRectangle);
        this.setZLevel(10);
        this.drawWarpLabel = true;
        this.transition = new ScaleTransition(0L, 0.0f, 0.0f);
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22764) {
            int originalZ = this.getZLevel();
            this.calculateHoverState(mouseX, mouseY);
            this.transition.setCurrentScale(this.parent.scaledGrid.getScaleFactor());
            if (this.field_22762) {
                this.setZLevel(19);
            }
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            if (this.field_22762) {
                this.renderForegroundLayer(guiGraphics, this.foregroundTexture.location());
            }
            if (this.drawWarpLabel && (!SettingsManager.get().general.hideWarpLabelsUntilIslandHovered || this.parent.method_25367())) {
                this.renderMessageString(guiGraphics, this.buttonRectangle.getWidth() / 2.0f, this.buttonRectangle.getHeight(), Color.WHITE);
            }
            this.setZLevel(originalZ);
        }
    }

    public String getWarpCommand() {
        return this.warp.getWarpCommand();
    }

    public int getWarpSlotIndex() {
        return this.warp.slotIndex();
    }

    public Island getIsland() {
        return this.parent.island;
    }

    public Warp getWarp() {
        return this.warp;
    }

    public void setDrawWarpLabel(boolean drawWarpLabel) {
        this.drawWarpLabel = drawWarpLabel;
    }
}

